/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.global;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tencent.polaris.api.config.global.SystemConfig;
import com.tencent.polaris.factory.config.global.ClusterConfigImpl;
import com.tencent.polaris.factory.config.global.FlowCacheConfigImpl;
import com.tencent.polaris.factory.config.global.FlowConfigImpl;
import com.tencent.polaris.factory.util.ConfigUtils;
import java.util.Collections;
import java.util.Map;

public class SystemConfigImpl
implements SystemConfig {
    @JsonProperty
    private FlowConfigImpl flow;
    @JsonProperty
    private FlowCacheConfigImpl flowCache;
    @JsonProperty
    private ClusterConfigImpl discoverCluster;
    @JsonProperty
    private ClusterConfigImpl configCluster;
    @JsonProperty
    private ClusterConfigImpl healthCheckCluster;
    @JsonProperty
    private ClusterConfigImpl monitorCluster;
    @JsonProperty
    private Map<String, String> variables;

    @Override
    public ClusterConfigImpl getDiscoverCluster() {
        return this.discoverCluster;
    }

    @Override
    public ClusterConfigImpl getConfigCluster() {
        return this.configCluster;
    }

    @Override
    public ClusterConfigImpl getHealthCheckCluster() {
        return this.healthCheckCluster;
    }

    @Override
    public ClusterConfigImpl getMonitorCluster() {
        return this.monitorCluster;
    }

    @Override
    public FlowCacheConfigImpl getFlowCache() {
        return this.flowCache;
    }

    @Override
    public Map<String, String> getVariables() {
        if (null == this.variables) {
            return Collections.emptyMap();
        }
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    @Override
    public void verify() {
        ConfigUtils.validateNull(this.flowCache, "system.flowCache");
        ConfigUtils.validateNull(this.discoverCluster, "system.discoverCluster");
        ConfigUtils.validateNull(this.discoverCluster, "system.configCluster");
        ConfigUtils.validateNull(this.healthCheckCluster, "system.healthCheckCluster");
        ConfigUtils.validateNull(this.monitorCluster, "system.monitorCluster");
        this.flowCache.verify();
        this.discoverCluster.verify();
        this.configCluster.verify();
        this.healthCheckCluster.verify();
        this.monitorCluster.verify();
        this.flow.verify();
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (null == this.discoverCluster) {
            this.discoverCluster = new ClusterConfigImpl();
        }
        if (null == this.configCluster) {
            this.configCluster = new ClusterConfigImpl();
        }
        if (null == this.healthCheckCluster) {
            this.healthCheckCluster = new ClusterConfigImpl();
        }
        if (null == this.monitorCluster) {
            this.monitorCluster = new ClusterConfigImpl();
        }
        if (null == this.flowCache) {
            this.flowCache = new FlowCacheConfigImpl();
        }
        if (null == this.flow) {
            this.flow = new FlowConfigImpl();
        }
        if (null != defaultObject) {
            SystemConfig systemConfig = (SystemConfig)defaultObject;
            this.discoverCluster.setDefault(systemConfig.getDiscoverCluster());
            this.configCluster.setDefault(systemConfig.getConfigCluster());
            this.healthCheckCluster.setDefault(systemConfig.getHealthCheckCluster());
            this.monitorCluster.setDefault(systemConfig.getMonitorCluster());
            this.flowCache.setDefault(systemConfig.getFlowCache());
            this.flow.setDefault(systemConfig.getFlow());
            if (null == this.variables) {
                this.setVariables(systemConfig.getVariables());
            }
        }
    }

    @Override
    public FlowConfigImpl getFlow() {
        return this.flow;
    }

    public void setFlow(FlowConfigImpl flow) {
        this.flow = flow;
    }

    public String toString() {
        return "SystemConfigImpl{flow=" + this.flow + ", flowCache=" + this.flowCache + ", discoverCluster=" + this.discoverCluster + ", configCluster=" + this.configCluster + ", healthCheckCluster=" + this.healthCheckCluster + ", monitorCluster=" + this.monitorCluster + ", variables=" + this.variables + '}';
    }
}

