/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.tencent.polaris.api.config.ConfigProvider;
import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.factory.config.consumer.ConsumerConfigImpl;
import com.tencent.polaris.factory.config.global.GlobalConfigImpl;
import com.tencent.polaris.factory.config.provider.ProviderConfigImpl;
import com.tencent.polaris.factory.util.ConfigUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class ConfigurationImpl
implements Configuration {
    private static final Map<String, Configuration> configProviders = new HashMap<String, Configuration>();
    @JsonIgnore
    private final String defaultConfigName;
    @JsonProperty
    private GlobalConfigImpl global;
    @JsonProperty
    private ConsumerConfigImpl consumer;
    @JsonProperty
    private ProviderConfigImpl provider;

    @Override
    public GlobalConfigImpl getGlobal() {
        return this.global;
    }

    public void setGlobal(GlobalConfigImpl global) {
        this.global = global;
    }

    @Override
    public ConsumerConfigImpl getConsumer() {
        return this.consumer;
    }

    public void setConsumer(ConsumerConfigImpl consumer) {
        this.consumer = consumer;
    }

    @Override
    public ProviderConfigImpl getProvider() {
        return this.provider;
    }

    public void setProvider(ProviderConfigImpl provider) {
        this.provider = provider;
    }

    @Override
    public void verify() {
        ConfigUtils.validateNull(this.global, "global");
        ConfigUtils.validateNull(this.consumer, "consumer");
        ConfigUtils.validateNull(this.provider, "provider");
        this.global.verify();
        this.consumer.verify();
        this.provider.verify();
    }

    public ConfigurationImpl() {
        this.defaultConfigName = "default";
    }

    public ConfigurationImpl(String defaultConfigName) {
        this.defaultConfigName = defaultConfigName;
    }

    private Configuration getDefaultConfig() {
        Configuration configuration = null;
        if (StringUtils.isNotBlank((String)this.defaultConfigName)) {
            configuration = configProviders.get(this.defaultConfigName);
        }
        if (null == configuration) {
            return configProviders.get("default");
        }
        return configuration;
    }

    public void setDefault() {
        this.setDefault(this.getDefaultConfig());
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (null == this.global) {
            this.global = new GlobalConfigImpl();
        }
        if (null == this.consumer) {
            this.consumer = new ConsumerConfigImpl();
        }
        if (null == this.provider) {
            this.provider = new ProviderConfigImpl();
        }
        if (null != defaultObject) {
            Configuration configuration = (Configuration)defaultObject;
            this.global.setDefault(configuration.getGlobal());
            this.consumer.setDefault(configuration.getConsumer());
            this.provider.setDefault(configuration.getProvider());
        }
    }

    public String toString() {
        return "ConfigurationImpl{global=" + this.global + ", consumer=" + this.consumer + ", provider=" + this.provider + '}';
    }

    static {
        ServiceLoader<ConfigProvider> providers = ServiceLoader.load(ConfigProvider.class);
        for (ConfigProvider provider : providers) {
            configProviders.put(provider.getName(), provider.getDefaultConfig());
        }
    }
}

