/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.global;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tencent.polaris.api.config.global.GlobalConfig;
import com.tencent.polaris.factory.config.global.APIConfigImpl;
import com.tencent.polaris.factory.config.global.ServerConnectorConfigImpl;
import com.tencent.polaris.factory.config.global.StatReporterConfigImpl;
import com.tencent.polaris.factory.config.global.SystemConfigImpl;
import com.tencent.polaris.factory.util.ConfigUtils;

public class GlobalConfigImpl
implements GlobalConfig {
    @JsonProperty
    private SystemConfigImpl system;
    @JsonProperty
    private APIConfigImpl api;
    @JsonProperty
    private ServerConnectorConfigImpl serverConnector;
    @JsonProperty
    private StatReporterConfigImpl statReporter;

    @Override
    public SystemConfigImpl getSystem() {
        return this.system;
    }

    @Override
    public APIConfigImpl getAPI() {
        return this.api;
    }

    @Override
    public ServerConnectorConfigImpl getServerConnector() {
        return this.serverConnector;
    }

    @Override
    public StatReporterConfigImpl getStatReporter() {
        return this.statReporter;
    }

    public void setServerConnector(ServerConnectorConfigImpl serverConnector) {
        this.serverConnector = serverConnector;
    }

    @Override
    public void verify() {
        ConfigUtils.validateNull(this.system, "system");
        ConfigUtils.validateNull(this.api, "api");
        ConfigUtils.validateNull(this.serverConnector, "serverConnector");
        ConfigUtils.validateNull(this.statReporter, "statReporter");
        this.system.verify();
        this.api.verify();
        this.serverConnector.verify();
        this.statReporter.verify();
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (null == this.system) {
            this.system = new SystemConfigImpl();
        }
        if (null == this.api) {
            this.api = new APIConfigImpl();
        }
        if (null == this.serverConnector) {
            this.serverConnector = new ServerConnectorConfigImpl();
        }
        if (null == this.statReporter) {
            this.statReporter = new StatReporterConfigImpl();
        }
        if (null != defaultObject) {
            GlobalConfig globalConfig = (GlobalConfig)defaultObject;
            this.system.setDefault(globalConfig.getSystem());
            this.api.setDefault(globalConfig.getAPI());
            this.serverConnector.setDefault(globalConfig.getServerConnector());
            this.statReporter.setDefault(globalConfig.getStatReporter());
        }
    }

    public String toString() {
        return "GlobalConfigImpl{system=" + this.system + "api=" + this.api + ", serverConnector=" + this.serverConnector + '}';
    }
}

