/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.api.rpc;

import com.tencent.polaris.api.utils.StringUtils;
import java.util.Map;

public class CreateConfigFileRequest {
    private String namespace;
    private String group;
    private String filename;
    private String content;
    private Map<String, String> labels;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public void verify() {
        if (StringUtils.isBlank((String)this.getNamespace())) {
            throw new IllegalArgumentException("namespace cannot be empty.");
        }
        if (StringUtils.isBlank((String)this.getGroup())) {
            throw new IllegalArgumentException("file group cannot be empty.");
        }
        if (StringUtils.isBlank((String)this.getFilename())) {
            throw new IllegalArgumentException("file name cannot be empty.");
        }
    }

    public static final class Builder {
        private String namespace;
        private String group;
        private String filename;
        private String content;
        private Map<String, String> labels;

        private Builder() {
        }

        public static Builder aCreateConfigFileRequest() {
            return new Builder();
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder labels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public CreateConfigFileRequest build() {
            CreateConfigFileRequest createConfigFileRequest = new CreateConfigFileRequest();
            createConfigFileRequest.setNamespace(this.namespace);
            createConfigFileRequest.setGroup(this.group);
            createConfigFileRequest.setFilename(this.filename);
            createConfigFileRequest.setContent(this.content);
            createConfigFileRequest.setLabels(this.labels);
            return createConfigFileRequest;
        }
    }
}

