/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.api.rpc;

import com.tencent.polaris.api.utils.StringUtils;

public class ReleaseConfigFileRequest {
    private String namespace;
    private String group;
    private String filename;
    private String releaseName;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public void setReleaseName(String releaseName) {
        this.releaseName = releaseName;
    }

    public void verify() {
        if (StringUtils.isBlank((String)this.getNamespace())) {
            throw new IllegalArgumentException("namespace cannot be empty.");
        }
        if (StringUtils.isBlank((String)this.getGroup())) {
            throw new IllegalArgumentException("file group cannot be empty.");
        }
        if (StringUtils.isBlank((String)this.getFilename())) {
            throw new IllegalArgumentException("file name cannot be empty.");
        }
    }

    public static final class Builder {
        private String namespace;
        private String group;
        private String filename;
        private String releaseName;

        private Builder() {
        }

        public static Builder aReleaseConfigFileRequest() {
            return new Builder();
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder releaseName(String releaseName) {
            this.releaseName = releaseName;
            return this;
        }

        public ReleaseConfigFileRequest build() {
            ReleaseConfigFileRequest releaseConfigFileRequest = new ReleaseConfigFileRequest();
            releaseConfigFileRequest.filename = this.filename;
            releaseConfigFileRequest.namespace = this.namespace;
            releaseConfigFileRequest.releaseName = this.releaseName;
            releaseConfigFileRequest.group = this.group;
            return releaseConfigFileRequest;
        }
    }
}

