/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.internal;

import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.configuration.ConfigFile;
import com.tencent.polaris.api.plugin.configuration.ConfigFileConnector;
import com.tencent.polaris.api.plugin.configuration.ConfigFileResponse;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.client.internal.AbstractConfigFileRepo;
import com.tencent.polaris.configuration.client.internal.ConfigFileLongPollingService;
import com.tencent.polaris.configuration.client.internal.ConfigFilePersistentHandler;
import com.tencent.polaris.configuration.client.internal.ExponentialRetryPolicy;
import com.tencent.polaris.configuration.client.internal.RetryPolicy;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class RemoteConfigFileRepo
extends AbstractConfigFileRepo {
    private static final long INIT_VERSION = 0L;
    private static final int PULL_CONFIG_RETRY_TIMES = 3;
    private static final ScheduledExecutorService pullExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("Configuration-Pull"));
    private final AtomicReference<ConfigFile> remoteConfigFile = new AtomicReference();
    private final AtomicLong notifiedVersion = new AtomicLong(0L);
    private final ConfigFileConnector configFileConnector;
    private final RetryPolicy retryPolicy = new ExponentialRetryPolicy(1L, 120L);
    private ConfigFilePersistentHandler configFilePersistHandler;
    private final boolean fallbackToLocalCache;

    public RemoteConfigFileRepo(SDKContext sdkContext, ConfigFileLongPollingService configFileLongPollingService, ConfigFileConnector configFileConnector, ConfigFileMetadata configFileMetadata) {
        this(sdkContext, configFileLongPollingService, configFileConnector, configFileMetadata, null);
    }

    public RemoteConfigFileRepo(SDKContext sdkContext, ConfigFileLongPollingService configFileLongPollingService, ConfigFileConnector configFileConnector, ConfigFileMetadata configFileMetadata, ConfigFilePersistentHandler configFilePersistHandler) {
        super(sdkContext, configFileMetadata);
        if (configFileConnector != null) {
            this.configFileConnector = configFileConnector;
        } else {
            String configFileConnectorType = sdkContext.getConfig().getConfigFile().getServerConnector().getConnectorType();
            this.configFileConnector = (ConfigFileConnector)sdkContext.getExtensions().getPlugins().getPlugin(PluginTypes.CONFIG_FILE_CONNECTOR.getBaseType(), configFileConnectorType);
        }
        if (configFilePersistHandler != null) {
            this.configFilePersistHandler = configFilePersistHandler;
        } else {
            try {
                this.configFilePersistHandler = new ConfigFilePersistentHandler(sdkContext);
            }
            catch (IOException e) {
                LOGGER.warn("config file persist handler init fail:" + e.getMessage(), (Throwable)e);
            }
        }
        this.fallbackToLocalCache = sdkContext.getConfig().getConfigFile().getServerConnector().getFallbackToLocalCache();
        this.pull();
        this.addToLongPollingPool(configFileLongPollingService, configFileMetadata);
        this.startCheckVersionTask();
    }

    private void addToLongPollingPool(ConfigFileLongPollingService configFileLongPollingService, ConfigFileMetadata configFileMetadata) {
        ConfigFile configFile = this.remoteConfigFile.get();
        if (configFile == null) {
            configFile = new ConfigFile(configFileMetadata.getNamespace(), configFileMetadata.getFileGroup(), configFileMetadata.getFileName());
            configFile.setVersion(0L);
        }
        configFileLongPollingService.addConfigFile(this);
    }

    @Override
    public String getContent() {
        return this.remoteConfigFile.get() != null ? this.remoteConfigFile.get().getContent() : null;
    }

    public long getConfigFileVersion() {
        if (this.remoteConfigFile.get() == null) {
            return 0L;
        }
        return this.remoteConfigFile.get().getVersion();
    }

    @Override
    protected void doPull() {
        long startTime = System.currentTimeMillis();
        ConfigFile pullConfigFileReq = new ConfigFile(this.configFileMetadata.getNamespace(), this.configFileMetadata.getFileGroup(), this.configFileMetadata.getFileName());
        pullConfigFileReq.setVersion(this.notifiedVersion.get());
        LOGGER.info("[Config] start pull config file. config file = {}, version = {}", (Object)this.configFileMetadata, (Object)this.notifiedVersion.get());
        int retryTimes = 0;
        while (retryTimes < 3) {
            try {
                ConfigFileResponse response = this.configFileConnector.getConfigFile(pullConfigFileReq);
                this.retryPolicy.success();
                long pulledConfigFileVersion = response.getConfigFile() != null ? response.getConfigFile().getVersion() : -1L;
                LOGGER.info("[Config] pull config file finished. config file = {}, code = {}, version = {}, duration = {} ms", new Object[]{this.configFileMetadata, response.getCode(), pulledConfigFileVersion, System.currentTimeMillis() - startTime});
                if (response.getCode() == 200000) {
                    ConfigFile pulledConfigFile = response.getConfigFile();
                    if (this.remoteConfigFile.get() == null || pulledConfigFile.getVersion() >= this.remoteConfigFile.get().getVersion()) {
                        ConfigFile copiedConfigFile = this.deepCloneConfigFile(pulledConfigFile);
                        this.remoteConfigFile.set(copiedConfigFile);
                        this.fireChangeEvent(copiedConfigFile.getContent());
                        this.configFilePersistHandler.asyncSaveConfigFile(pulledConfigFile);
                    }
                    return;
                }
                if (response.getCode() == 400202) {
                    LOGGER.warn("[Config] config file not found, please check whether config file released. {}", (Object)this.configFileMetadata);
                    this.configFilePersistHandler.asyncDeleteConfigFile(new ConfigFile(this.configFileMetadata.getNamespace(), this.configFileMetadata.getFileGroup(), this.configFileMetadata.getFileName()));
                    if (this.remoteConfigFile.get() != null) {
                        this.remoteConfigFile.set(null);
                        this.fireChangeEvent(null);
                    }
                    return;
                }
                LOGGER.error("[Config] pull response without expected code. retry times = {}, code = {}", (Object)retryTimes, (Object)response.getCode());
                this.retryPolicy.fail();
                this.retryPolicy.executeDelay();
                this.fallbackIfNecessary(++retryTimes, pullConfigFileReq);
            }
            catch (Throwable t) {
                LOGGER.error("[Config] failed to pull config file. retry times = " + retryTimes, t);
                this.retryPolicy.fail();
                this.retryPolicy.executeDelay();
                this.fallbackIfNecessary(++retryTimes, pullConfigFileReq);
            }
        }
    }

    private void fallbackIfNecessary(int retryTimes, ConfigFile configFileReq) {
        if (retryTimes >= 3 && this.fallbackToLocalCache) {
            ConfigFile configFileRes = this.configFilePersistHandler.loadPersistedConfigFile(configFileReq);
            if (configFileRes != null) {
                LOGGER.info("[Config] failed to pull config file from remote,fallback to local cache success.{}.", (Object)configFileRes);
                this.remoteConfigFile.set(configFileRes);
                this.fireChangeEvent(configFileRes.getContent());
                return;
            }
            LOGGER.info("[Config] failed to pull config file from remote,fallback to local cache fail.{}.", (Object)configFileReq);
        }
    }

    public void onLongPollNotified(long newVersion) {
        if (this.remoteConfigFile.get() != null && this.remoteConfigFile.get().getVersion() >= newVersion) {
            return;
        }
        this.notifiedVersion.set(newVersion);
        pullExecutorService.submit(this::pull);
    }

    private void startCheckVersionTask() {
        pullExecutorService.scheduleAtFixedRate(() -> {
            long pulledVersion;
            if (this.notifiedVersion == null || this.notifiedVersion.get() == 0L) {
                return;
            }
            long l = pulledVersion = this.remoteConfigFile.get() != null ? this.remoteConfigFile.get().getVersion() : 0L;
            if (this.notifiedVersion.get() > pulledVersion) {
                LOGGER.info("[Config] notified version greater than pulled version, will pull config file.file = {}, notified version = {}, pulled version = {}", new Object[]{this.getConfigFileMetadata(), this.notifiedVersion, pulledVersion});
                this.pull();
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    private ConfigFile deepCloneConfigFile(ConfigFile sourceConfigFile) {
        ConfigFile configFile = new ConfigFile(sourceConfigFile.getNamespace(), sourceConfigFile.getFileGroup(), sourceConfigFile.getFileName());
        configFile.setContent(sourceConfigFile.getContent());
        configFile.setVersion(sourceConfigFile.getVersion());
        configFile.setMd5(sourceConfigFile.getMd5());
        return configFile;
    }
}

