/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.internal;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.tencent.polaris.api.plugin.configuration.ConfigFile;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.client.util.Utils;
import com.tencent.polaris.factory.util.FileUtils;
import com.tencent.polaris.logging.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class ConfigFilePersistentHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigFilePersistentHandler.class);
    private final String persistDirPath;
    private final int maxWriteRetry;
    private final int maxReadRetry;
    private final long retryInterval;
    private final boolean isAllowPersist;
    private final String connectorType;
    private static final ExecutorService persistExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("configFile-persistent-handler"));

    public ConfigFilePersistentHandler(SDKContext sdkContext) throws IOException {
        String persistDir = sdkContext.getConfig().getConfigFile().getServerConnector().getPersistDir();
        this.maxReadRetry = sdkContext.getConfig().getConfigFile().getServerConnector().getPersistMaxReadRetry();
        this.maxWriteRetry = sdkContext.getConfig().getConfigFile().getServerConnector().getPersistMaxWriteRetry();
        this.retryInterval = sdkContext.getConfig().getConfigFile().getServerConnector().getPersistRetryInterval();
        this.isAllowPersist = sdkContext.getConfig().getConfigFile().getServerConnector().getPersistEnable();
        this.connectorType = sdkContext.getConfig().getConfigFile().getServerConnector().getConnectorType();
        this.persistDirPath = Utils.translatePath((String)persistDir);
        FileUtils.dirPathCheck((String)this.persistDirPath);
    }

    private boolean isAllowPersistToFile() {
        return this.isAllowPersist && !"localFile".equals(this.connectorType);
    }

    public void asyncDeleteConfigFile(ConfigFile configFile) {
        if (!persistExecutor.isShutdown() && this.isAllowPersistToFile()) {
            persistExecutor.execute(new DeleteTask(configFile));
        }
    }

    public void deleteFileConfig(ConfigFile configFile) {
        String fileName = ConfigFilePersistentHandler.configFileToFileName(configFile);
        String persistFilePath = this.persistDirPath + File.separator + fileName;
        try {
            Files.deleteIfExists(FileSystems.getDefault().getPath(persistFilePath, new String[0]));
        }
        catch (IOException e) {
            LOG.error("fail to delete cache file {}", (Object)persistFilePath);
        }
        String lockFileName = fileName + ".lock";
        String persistFileLockPath = this.persistDirPath + File.separator + lockFileName;
        try {
            Files.deleteIfExists(FileSystems.getDefault().getPath(persistFileLockPath, new String[0]));
        }
        catch (IOException e) {
            LOG.error("fail to delete cache lock file {}", (Object)persistFileLockPath);
        }
    }

    public void asyncSaveConfigFile(ConfigFile configFile) {
        if (!persistExecutor.isShutdown() && this.isAllowPersistToFile()) {
            persistExecutor.execute(new SaveTask(configFile));
        }
    }

    public void saveConfigFile(ConfigFile configFile) {
        int retryTimes;
        LOG.info("start to save config file {}", (Object)configFile);
        for (retryTimes = 0; retryTimes <= this.maxWriteRetry; ++retryTimes) {
            Path path = this.doSaveConfigFile(configFile);
            if (null == path) continue;
            LOG.info("end to save config file {} to {}", (Object)configFile, (Object)path);
            return;
        }
        LOG.error("fail to persist config file {} after retry {}", (Object)configFile, (Object)retryTimes);
    }

    private static String configFileToFileName(ConfigFile configFile) {
        try {
            String encodedNamespace = URLEncoder.encode(configFile.getNamespace(), "UTF-8");
            String encodedFileGroup = URLEncoder.encode(configFile.getFileGroup(), "UTF-8");
            String encodeFileName = URLEncoder.encode(configFile.getFileName(), "UTF-8");
            return String.format("%s#%s#%s.yaml", encodedNamespace, encodedFileGroup, encodeFileName);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTmpFile(File persistTmpFile, File persistLockFile, ConfigFile configFile) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(persistLockFile, "rw");
             FileChannel channel = raf.getChannel();){
            FileLock lock = channel.tryLock();
            if (lock == null) {
                throw new IOException("fail to lock file " + persistTmpFile.getAbsolutePath() + ", ignore and retry later");
            }
            try {
                this.doWriteTmpFile(persistTmpFile, configFile);
            }
            finally {
                lock.release();
            }
        }
    }

    private void doWriteTmpFile(File persistTmpFile, ConfigFile configFile) throws IOException {
        if (!persistTmpFile.exists() && !persistTmpFile.createNewFile()) {
            LOG.warn("tmp file {} already exists", (Object)persistTmpFile.getAbsolutePath());
        }
        try (FileOutputStream outputFile = new FileOutputStream(persistTmpFile);){
            String jsonAsYaml = new YAMLMapper().writeValueAsString((Object)configFile);
            outputFile.write(jsonAsYaml.getBytes(StandardCharsets.UTF_8));
            outputFile.flush();
        }
    }

    private Path doSaveConfigFile(ConfigFile configFile) {
        String fileName = ConfigFilePersistentHandler.configFileToFileName(configFile);
        String tmpFileName = fileName + ".tmp";
        String lockFileName = fileName + ".lock";
        String persistFilePathStr = this.persistDirPath + File.separator + fileName;
        Path persistPath = FileSystems.getDefault().getPath(persistFilePathStr, new String[0]);
        File persistTmpFile = new File(this.persistDirPath + File.separator + tmpFileName);
        File persistLockFile = new File(this.persistDirPath + File.separator + lockFileName);
        try {
            if (!persistLockFile.exists() && !persistLockFile.createNewFile()) {
                LOG.warn("lock file {} already exists", (Object)persistLockFile.getAbsolutePath());
            }
            this.writeTmpFile(persistTmpFile, persistLockFile, configFile);
            Files.move(FileSystems.getDefault().getPath(persistTmpFile.getAbsolutePath(), new String[0]), persistPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            LOG.error("fail to write file :" + persistTmpFile, (Throwable)e);
            return null;
        }
        return persistPath.toAbsolutePath();
    }

    public ConfigFile loadPersistedConfigFile(ConfigFile configFile) {
        int retryTimes;
        String fileName = ConfigFilePersistentHandler.configFileToFileName(configFile);
        String persistFilePathStr = this.persistDirPath + File.separator + fileName;
        Path persistPath = FileSystems.getDefault().getPath(persistFilePathStr, new String[0]);
        ConfigFile resConfigFile = null;
        for (retryTimes = 0; retryTimes <= this.maxReadRetry; ++retryTimes) {
            resConfigFile = this.loadConfigFile(persistPath.toFile(), configFile);
            if (null != resConfigFile) break;
            Utils.sleepUninterrupted((long)this.retryInterval);
        }
        if (null == resConfigFile) {
            LOG.debug("fail to read config file from {} after retry {} times", (Object)fileName, (Object)retryTimes);
            return null;
        }
        return resConfigFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigFile loadConfigFile(File persistFile, ConfigFile configFile) {
        if (null == persistFile || !persistFile.exists()) {
            return null;
        }
        FileInputStream inputStream = null;
        InputStreamReader reader = null;
        Yaml yaml = new Yaml();
        try {
            inputStream = new FileInputStream(persistFile);
            reader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
            ConfigFile resConfigFile = new ConfigFile(configFile.getNamespace(), configFile.getFileGroup(), configFile.getFileName());
            Map jsonMap = (Map)yaml.load((Reader)reader);
            resConfigFile.setContent(jsonMap.get("content").toString());
            resConfigFile.setMd5(jsonMap.get("md5").toString());
            resConfigFile.setVersion(Long.valueOf(String.valueOf(jsonMap.get("version"))).longValue());
            ConfigFile configFile2 = resConfigFile;
            return configFile2;
        }
        catch (IOException e) {
            LOG.warn("fail to read file :" + persistFile.getAbsoluteFile(), (Throwable)e);
            ConfigFile configFile3 = null;
            return configFile3;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOG.warn("fail to close reader for :" + persistFile.getAbsoluteFile(), (Throwable)e);
                }
            }
            if (null != inputStream) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    LOG.warn("fail to close stream for :" + persistFile.getAbsoluteFile(), (Throwable)e);
                }
            }
        }
    }

    private class SaveTask
    implements Runnable {
        private ConfigFile configFile;

        public SaveTask(ConfigFile configFile) {
            this.configFile = configFile;
        }

        @Override
        public void run() {
            ConfigFilePersistentHandler.this.saveConfigFile(this.configFile);
        }
    }

    private class DeleteTask
    implements Runnable {
        private ConfigFile configFile;

        public DeleteTask(ConfigFile configFile) {
            this.configFile = configFile;
        }

        @Override
        public void run() {
            ConfigFilePersistentHandler.this.deleteFileConfig(this.configFile);
        }
    }
}

