/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.configuration.ConfigFile;
import com.tencent.polaris.api.plugin.configuration.ConfigFileConnector;
import com.tencent.polaris.api.plugin.configuration.ConfigFileResponse;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.client.internal.ConfigFileLongPollingService;
import com.tencent.polaris.configuration.client.internal.DefaultConfigFileMetadata;
import com.tencent.polaris.configuration.client.internal.ExponentialRetryPolicy;
import com.tencent.polaris.configuration.client.internal.RemoteConfigFileRepo;
import com.tencent.polaris.configuration.client.internal.RetryPolicy;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class DefaultConfigFileLongPollingService
implements ConfigFileLongPollingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConfigFileLongPollingService.class);
    private static ConfigFileLongPollingService instance;
    private final ConfigFileConnector configFileConnector;
    private final ExecutorService longPollingService;
    private final Map<ConfigFileMetadata, RemoteConfigFileRepo> configFilePool;
    private final Map<ConfigFileMetadata, Long> notifiedVersion;
    private final AtomicReference<Boolean> started = new AtomicReference<Boolean>(false);
    private final RetryPolicy retryPolicy;

    DefaultConfigFileLongPollingService(SDKContext sdkContext, ConfigFileConnector configFileConnector) {
        this.configFilePool = Maps.newConcurrentMap();
        this.notifiedVersion = Maps.newConcurrentMap();
        this.retryPolicy = new ExponentialRetryPolicy(1L, 120L);
        if (configFileConnector != null) {
            this.configFileConnector = configFileConnector;
        } else {
            String configFileConnectorType = sdkContext.getConfig().getConfigFile().getServerConnector().getConnectorType();
            this.configFileConnector = (ConfigFileConnector)sdkContext.getExtensions().getPlugins().getPlugin(PluginTypes.CONFIG_FILE_CONNECTOR.getBaseType(), configFileConnectorType);
        }
        NamedThreadFactory threadFactory = new NamedThreadFactory("Configuration-LongPolling");
        this.longPollingService = Executors.newSingleThreadExecutor((ThreadFactory)threadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigFileLongPollingService getInstance(SDKContext sdkContext) {
        if (instance != null) return instance;
        Class<DefaultConfigFileLongPollingService> clazz = DefaultConfigFileLongPollingService.class;
        synchronized (DefaultConfigFileLongPollingService.class) {
            if (instance != null) return instance;
            instance = new DefaultConfigFileLongPollingService(sdkContext, null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void addConfigFile(RemoteConfigFileRepo remoteConfigFileRepo) {
        ConfigFileMetadata configFileMetadata = remoteConfigFileRepo.getConfigFileMetadata();
        long version = remoteConfigFileRepo.getConfigFileVersion();
        LOGGER.info("[Config] add long polling config file. file = {}, version = {}", (Object)configFileMetadata, (Object)version);
        this.configFilePool.putIfAbsent(configFileMetadata, remoteConfigFileRepo);
        this.notifiedVersion.putIfAbsent(configFileMetadata, version);
        if (!this.started.get().booleanValue()) {
            this.startLongPollingTask();
        }
    }

    private void startLongPollingTask() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        try {
            this.longPollingService.submit(() -> {
                try {
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.doLongPolling();
            });
        }
        catch (Throwable t) {
            this.started.set(false);
        }
    }

    private void doLongPolling() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                List<ConfigFile> watchConfigFiles = this.assembleWatchConfigFiles();
                LOGGER.debug("[Config] do long polling. config file size = {}, delay time = {}", (Object)watchConfigFiles.size(), (Object)this.retryPolicy.getCurrentDelayTime());
                ConfigFileResponse response = this.configFileConnector.watchConfigFiles(watchConfigFiles);
                this.retryPolicy.success();
                int responseCode = response.getCode();
                if (responseCode == 200000 && response.getConfigFile() != null) {
                    ConfigFile changedConfigFile = response.getConfigFile();
                    DefaultConfigFileMetadata metadata = new DefaultConfigFileMetadata(changedConfigFile.getNamespace(), changedConfigFile.getFileGroup(), changedConfigFile.getFileName());
                    long newNotifiedVersion = changedConfigFile.getVersion();
                    long oldNotifiedVersion = this.notifiedVersion.get(metadata);
                    long maxVersion = Math.max(newNotifiedVersion, oldNotifiedVersion);
                    this.notifiedVersion.put(metadata, maxVersion);
                    LOGGER.info("[Config] received change event by long polling. file = {}, new version = {}, old version = {}", new Object[]{metadata, newNotifiedVersion, oldNotifiedVersion});
                    RemoteConfigFileRepo remoteConfigFileRepo = this.configFilePool.get(metadata);
                    remoteConfigFileRepo.onLongPollNotified(maxVersion);
                    continue;
                }
                if (responseCode == 200001) {
                    LOGGER.info("[Config] long polling result: data no change");
                    continue;
                }
                LOGGER.error("[Config] long polling result with unexpect code. code = {}", (Object)responseCode);
                this.retryPolicy.fail();
                this.retryPolicy.executeDelay();
            }
            catch (Throwable t) {
                LOGGER.error("[Config] long polling failed.", t);
                this.retryPolicy.fail();
                this.retryPolicy.executeDelay();
            }
        }
    }

    private List<ConfigFile> assembleWatchConfigFiles() {
        ArrayList watchConfigFiles = Lists.newArrayList();
        for (Map.Entry<ConfigFileMetadata, RemoteConfigFileRepo> entry : this.configFilePool.entrySet()) {
            RemoteConfigFileRepo remoteConfigFileRepo = entry.getValue();
            ConfigFileMetadata metadata = remoteConfigFileRepo.getConfigFileMetadata();
            ConfigFile configFile = new ConfigFile(metadata.getNamespace(), metadata.getFileGroup(), metadata.getFileName());
            configFile.setVersion(this.notifiedVersion.get(metadata).longValue());
            watchConfigFiles.add(configFile);
        }
        return watchConfigFiles;
    }
}

