/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.internal;

import com.tencent.polaris.annonation.JustForTest;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.configuration.ConfigFile;
import com.tencent.polaris.api.plugin.configuration.ConfigFileConnector;
import com.tencent.polaris.api.plugin.configuration.ConfigFileResponse;
import com.tencent.polaris.api.plugin.filter.ConfigFileFilterChain;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.configuration.api.core.ConfigFileFormat;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.api.core.ConfigKVFile;
import com.tencent.polaris.configuration.client.internal.AbstractConfigFileRepo;
import com.tencent.polaris.configuration.client.internal.ConfigFileLongPullService;
import com.tencent.polaris.configuration.client.internal.ConfigFilePersistentHandler;
import com.tencent.polaris.configuration.client.internal.ConfigPropertiesFile;
import com.tencent.polaris.configuration.client.internal.ConfigYamlFile;
import com.tencent.polaris.configuration.client.internal.DefaultConfigFile;
import com.tencent.polaris.configuration.client.internal.RemoteConfigFileRepo;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigFileManager {
    private SDKContext context;
    private ConfigFileConnector connector;
    private ConfigFileFilterChain configFileFilterChain;
    private final Map<ConfigFileMetadata, com.tencent.polaris.configuration.api.core.ConfigFile> configFileCache = new ConcurrentHashMap<ConfigFileMetadata, com.tencent.polaris.configuration.api.core.ConfigFile>();
    private final Map<ConfigFileMetadata, ConfigKVFile> configPropertiesFileCache = new ConcurrentHashMap<ConfigFileMetadata, ConfigKVFile>();
    private ConfigFileLongPullService longPullService;
    private ConfigFilePersistentHandler persistentHandler;

    @JustForTest
    public ConfigFileManager() {
    }

    @JustForTest
    public ConfigFileManager(ConfigFileConnector connector) {
        this.connector = connector;
    }

    public ConfigFileManager(SDKContext sdkContext) {
        String configFileConnectorType = sdkContext.getConfig().getConfigFile().getServerConnector().getConnectorType();
        this.context = sdkContext;
        this.configFileFilterChain = new ConfigFileFilterChain(sdkContext.getExtensions().getPlugins(), sdkContext.getConfig().getConfigFile().getConfigFilterConfig());
        this.connector = (ConfigFileConnector)sdkContext.getExtensions().getPlugins().getPlugin(PluginTypes.CONFIG_FILE_CONNECTOR.getBaseType(), configFileConnectorType);
        this.longPullService = new ConfigFileLongPullService(this.context, this.connector);
        try {
            this.persistentHandler = new ConfigFilePersistentHandler(sdkContext);
        }
        catch (IOException e) {
            AbstractConfigFileRepo.LOGGER.warn("config file persist handler init fail:" + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.tencent.polaris.configuration.api.core.ConfigFile getConfigFile(ConfigFileMetadata configFileMetadata) {
        com.tencent.polaris.configuration.api.core.ConfigFile configFile = this.configFileCache.get(configFileMetadata);
        if (configFile == null) {
            ConfigFileManager configFileManager = this;
            synchronized (configFileManager) {
                configFile = this.configFileCache.get(configFileMetadata);
                if (configFile == null) {
                    configFile = this.createConfigFile(configFileMetadata);
                    this.configFileCache.put(configFileMetadata, configFile);
                }
            }
        }
        return configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigKVFile getConfigKVFile(ConfigFileMetadata configFileMetadata, ConfigFileFormat fileFormat) {
        ConfigKVFile configFile = this.configPropertiesFileCache.get(configFileMetadata);
        if (configFile == null) {
            ConfigFileManager configFileManager = this;
            synchronized (configFileManager) {
                configFile = this.configPropertiesFileCache.get(configFileMetadata);
                if (configFile == null) {
                    configFile = this.createConfigKVFile(configFileMetadata, fileFormat);
                    this.configPropertiesFileCache.put(configFileMetadata, configFile);
                }
            }
        }
        return configFile;
    }

    public ConfigFileResponse createConfigFile(ConfigFileMetadata configFileMetadata, String content) {
        ConfigFile configFile = new ConfigFile(configFileMetadata.getNamespace(), configFileMetadata.getFileGroup(), configFileMetadata.getFileName());
        configFile.setContent(content);
        return this.connector.createConfigFile(configFile);
    }

    public ConfigFileResponse updateConfigFile(ConfigFileMetadata configFileMetadata, String content) {
        ConfigFile configFile = new ConfigFile(configFileMetadata.getNamespace(), configFileMetadata.getFileGroup(), configFileMetadata.getFileName());
        configFile.setContent(content);
        return this.connector.updateConfigFile(configFile);
    }

    public ConfigFileResponse releaseConfigFile(ConfigFileMetadata configFileMetadata) {
        ConfigFile configFile = new ConfigFile(configFileMetadata.getNamespace(), configFileMetadata.getFileGroup(), configFileMetadata.getFileName());
        return this.connector.releaseConfigFile(configFile);
    }

    public com.tencent.polaris.configuration.api.core.ConfigFile createConfigFile(ConfigFileMetadata configFileMetadata) {
        RemoteConfigFileRepo configFileRepo = new RemoteConfigFileRepo(this.context, this.longPullService, this.configFileFilterChain, this.connector, configFileMetadata, this.persistentHandler);
        return new DefaultConfigFile(configFileMetadata.getNamespace(), configFileMetadata.getFileGroup(), configFileMetadata.getFileName(), configFileRepo, this.context.getConfig().getConfigFile());
    }

    public ConfigKVFile createConfigKVFile(ConfigFileMetadata configFileMetadata, ConfigFileFormat format) {
        RemoteConfigFileRepo configFileRepo = new RemoteConfigFileRepo(this.context, this.longPullService, this.configFileFilterChain, this.connector, configFileMetadata, this.persistentHandler);
        switch (format) {
            case Properties: {
                return new ConfigPropertiesFile(configFileMetadata.getNamespace(), configFileMetadata.getFileGroup(), configFileMetadata.getFileName(), configFileRepo, this.context.getConfig().getConfigFile());
            }
            case Yaml: {
                return new ConfigYamlFile(configFileMetadata.getNamespace(), configFileMetadata.getFileGroup(), configFileMetadata.getFileName(), configFileRepo, this.context.getConfig().getConfigFile());
            }
        }
        throw new IllegalArgumentException("KV file only support properties and yaml file.");
    }
}

