/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client;

import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.configuration.ConfigFileResponse;
import com.tencent.polaris.client.api.BaseEngine;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.api.core.ConfigFilePublishService;
import com.tencent.polaris.configuration.api.rpc.ConfigPublishRequest;
import com.tencent.polaris.configuration.api.rpc.CreateConfigFileRequest;
import com.tencent.polaris.configuration.api.rpc.ReleaseConfigFileRequest;
import com.tencent.polaris.configuration.api.rpc.UpdateConfigFileRequest;
import com.tencent.polaris.configuration.client.internal.ConfigFileManager;
import com.tencent.polaris.configuration.client.internal.DefaultConfigFileMetadata;
import com.tencent.polaris.configuration.client.util.ConfigFileUtils;

public class DefaultConfigFilePublishService
extends BaseEngine
implements ConfigFilePublishService {
    private ConfigFileManager configFileManager;

    public DefaultConfigFilePublishService(SDKContext sdkContext) {
        super(sdkContext);
    }

    protected void subInit() throws PolarisException {
        this.configFileManager = new ConfigFileManager(this.sdkContext);
    }

    public ConfigFileResponse createConfigFile(String namespace, String fileGroup, String fileName, String content) {
        return this.createConfigFile(new DefaultConfigFileMetadata(namespace, fileGroup, fileName), content);
    }

    public ConfigFileResponse createConfigFile(ConfigFileMetadata configFileMetadata, String content) {
        ConfigFileUtils.checkConfigFileMetadata(configFileMetadata);
        CreateConfigFileRequest request = new CreateConfigFileRequest();
        request.setFilename(configFileMetadata.getFileName());
        request.setGroup(configFileMetadata.getFileGroup());
        request.setNamespace(configFileMetadata.getNamespace());
        request.setContent(content);
        return this.configFileManager.createConfigFile(request);
    }

    public ConfigFileResponse updateConfigFile(String namespace, String fileGroup, String fileName, String content) {
        return this.updateConfigFile(new DefaultConfigFileMetadata(namespace, fileGroup, fileName), content);
    }

    public ConfigFileResponse updateConfigFile(ConfigFileMetadata configFileMetadata, String content) {
        ConfigFileUtils.checkConfigFileMetadata(configFileMetadata);
        UpdateConfigFileRequest request = new UpdateConfigFileRequest();
        request.setFilename(configFileMetadata.getFileName());
        request.setGroup(configFileMetadata.getFileGroup());
        request.setNamespace(configFileMetadata.getNamespace());
        request.setContent(content);
        return this.configFileManager.updateConfigFile(request);
    }

    public ConfigFileResponse releaseConfigFile(String namespace, String fileGroup, String fileName) {
        return this.releaseConfigFile(new DefaultConfigFileMetadata(namespace, fileGroup, fileName));
    }

    public ConfigFileResponse releaseConfigFile(ConfigFileMetadata configFileMetadata) {
        ReleaseConfigFileRequest request = new ReleaseConfigFileRequest();
        request.setFilename(configFileMetadata.getFileName());
        request.setGroup(configFileMetadata.getFileGroup());
        request.setNamespace(configFileMetadata.getNamespace());
        return this.release(request);
    }

    public ConfigFileResponse create(CreateConfigFileRequest request) {
        request.verify();
        return this.configFileManager.createConfigFile(request);
    }

    public ConfigFileResponse update(UpdateConfigFileRequest request) {
        request.verify();
        return this.configFileManager.updateConfigFile(request);
    }

    public ConfigFileResponse release(ReleaseConfigFileRequest request) {
        request.verify();
        return this.configFileManager.releaseConfigFile(request);
    }

    public ConfigFileResponse upsertAndPublish(ConfigPublishRequest request) {
        request.verify();
        return this.configFileManager.upsertAndPublish(request);
    }
}

