/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.internal;

import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.configuration.ConfigFile;
import com.tencent.polaris.api.plugin.configuration.ConfigFileGroup;
import com.tencent.polaris.api.plugin.configuration.ConfigFileGroupConnector;
import com.tencent.polaris.api.plugin.configuration.ConfigFileGroupMetadata;
import com.tencent.polaris.api.plugin.configuration.ConfigFileGroupResponse;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.client.internal.DefaultConfigFileGroup;
import com.tencent.polaris.configuration.client.internal.DefaultConfigFileMetadata;
import com.tencent.polaris.configuration.client.internal.DefaultRevisableConfigFileGroupPullService;
import com.tencent.polaris.configuration.client.internal.RetryableConfigFileGroupConnector;
import com.tencent.polaris.configuration.client.internal.RevisableConfigFileGroup;
import com.tencent.polaris.configuration.client.internal.RevisableConfigFileGroupPullService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigFileGroupManager {
    private final Map<com.tencent.polaris.configuration.api.core.ConfigFileGroupMetadata, RevisableConfigFileGroup> configFileGroupCache = new ConcurrentHashMap<com.tencent.polaris.configuration.api.core.ConfigFileGroupMetadata, RevisableConfigFileGroup>();
    private RetryableConfigFileGroupConnector rpcConnector;
    private RevisableConfigFileGroupPullService configFileGroupPullService;
    private final boolean enabled;

    public ConfigFileGroupManager(SDKContext sdkContext) {
        String configFileConnectorType = sdkContext.getConfig().getConfigFile().getServerConnector().getConnectorType();
        if (StringUtils.equals((String)configFileConnectorType, (String)"polaris")) {
            this.enabled = true;
            ConfigFileGroupConnector connector = (ConfigFileGroupConnector)sdkContext.getExtensions().getPlugins().getPlugin(PluginTypes.CONFIG_FILE_GROUP_CONNECTOR.getBaseType(), configFileConnectorType);
            this.rpcConnector = new RetryableConfigFileGroupConnector(connector, this.getCacheMissedRetryStrategy());
            this.configFileGroupPullService = new DefaultRevisableConfigFileGroupPullService(sdkContext, this.configFileGroupCache, connector);
        } else {
            this.enabled = false;
        }
    }

    public RetryableConfigFileGroupConnector.RetryableValidator getCacheMissedRetryStrategy() {
        return response -> {
            switch (response.getCode()) {
                case 200000: 
                case 400202: {
                    return false;
                }
            }
            return true;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.tencent.polaris.configuration.api.core.ConfigFileGroup getConfigFileGroup(com.tencent.polaris.configuration.api.core.ConfigFileGroupMetadata metadata) {
        if (!this.enabled) {
            throw new RuntimeException("Config file group manager is disabled.");
        }
        RevisableConfigFileGroup configFileGroup = this.configFileGroupCache.get(metadata);
        if (configFileGroup == null) {
            ConfigFileGroupManager configFileGroupManager = this;
            synchronized (configFileGroupManager) {
                configFileGroup = this.configFileGroupCache.get(metadata);
                if (configFileGroup == null && (configFileGroup = this.getConfigFileGroupFromRemote(metadata, "")) == null) {
                    return null;
                }
            }
        }
        return configFileGroup;
    }

    private RevisableConfigFileGroup getConfigFileGroupFromRemote(com.tencent.polaris.configuration.api.core.ConfigFileGroupMetadata metadata, String currentRevision) {
        ConfigFileGroupMetadata metadataRPCObj = new ConfigFileGroupMetadata();
        metadataRPCObj.setFileGroupName(metadata.getFileGroupName());
        metadataRPCObj.setNamespace(metadata.getNamespace());
        ConfigFileGroupResponse rpcResponse = this.rpcConnector.GetConfigFileMetadataList(metadataRPCObj, currentRevision);
        if (rpcResponse == null) {
            return null;
        }
        switch (rpcResponse.getCode()) {
            case 200000: {
                ConfigFileGroup configFileGroupObj = rpcResponse.getConfigFileGroup();
                String newRevision = rpcResponse.getRevision();
                List configFileList = configFileGroupObj.getConfigFileList();
                ArrayList<ConfigFileMetadata> configFileMetadataList = new ArrayList<ConfigFileMetadata>();
                for (ConfigFile configFile : configFileList) {
                    DefaultConfigFileMetadata configFileMetadata = new DefaultConfigFileMetadata(configFile.getNamespace(), configFile.getFileGroup(), configFile.getFileName());
                    configFileMetadataList.add(configFileMetadata);
                }
                DefaultConfigFileGroup configFileGroup = new DefaultConfigFileGroup(configFileGroupObj.getNamespace(), configFileGroupObj.getFileGroupName(), configFileMetadataList);
                RevisableConfigFileGroup revisableConfigFileGroup = new RevisableConfigFileGroup(configFileGroup, newRevision);
                this.cache(metadata, revisableConfigFileGroup);
                return revisableConfigFileGroup;
            }
            case 400202: {
                DefaultConfigFileGroup emptyConfigFileGroup = new DefaultConfigFileGroup(metadata.getNamespace(), metadata.getFileGroupName(), new ArrayList<ConfigFileMetadata>());
                RevisableConfigFileGroup emptyRevision = new RevisableConfigFileGroup(emptyConfigFileGroup, "");
                this.cache(metadata, emptyRevision);
                return emptyRevision;
            }
        }
        return null;
    }

    private void cache(com.tencent.polaris.configuration.api.core.ConfigFileGroupMetadata metadata, RevisableConfigFileGroup revisableConfigFileGroup) {
        this.configFileGroupCache.put(metadata, revisableConfigFileGroup);
        this.configFileGroupPullService.pullConfigFileGroup(revisableConfigFileGroup);
    }

    private void invalid(com.tencent.polaris.configuration.api.core.ConfigFileGroupMetadata metadata) {
        this.configFileGroupCache.remove(metadata);
    }

    public void setRpcConnector(RetryableConfigFileGroupConnector rpcConnector) {
        this.rpcConnector = rpcConnector;
    }

    public void setConfigFileGroupPullService(RevisableConfigFileGroupPullService configFileGroupPullService) {
        this.configFileGroupPullService = configFileGroupPullService;
    }
}

