/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.internal;

import com.google.common.collect.Lists;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.configuration.api.core.ConfigFileGroup;
import com.tencent.polaris.configuration.api.core.ConfigFileGroupChangeListener;
import com.tencent.polaris.configuration.api.core.ConfigFileGroupChangedEvent;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.client.internal.DefaultConfigFileGroupMetadata;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;

public class DefaultConfigFileGroup
extends DefaultConfigFileGroupMetadata
implements ConfigFileGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConfigFileGroup.class);
    protected List<ConfigFileMetadata> configFileMetadataList;
    protected static ExecutorService notifyExecutorService = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(DefaultConfigFileGroup.class.getSimpleName()));
    private final List<ConfigFileGroupChangeListener> listeners = Lists.newCopyOnWriteArrayList();

    public DefaultConfigFileGroup(String namespace, String fileGroupName, List<ConfigFileMetadata> configFileMetadataList) {
        super(namespace, fileGroupName);
        this.configFileMetadataList = configFileMetadataList;
    }

    public List<ConfigFileMetadata> getConfigFileMetadataList() {
        return this.configFileMetadataList;
    }

    public void addChangeListener(ConfigFileGroupChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeChangeListener(ConfigFileGroupChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void trigger(ConfigFileGroupChangedEvent event) {
        for (ConfigFileGroupChangeListener listener : this.listeners) {
            notifyExecutorService.submit(() -> {
                try {
                    long startTime = System.currentTimeMillis();
                    listener.onChange(event);
                    LOGGER.info("[Config] invoke config file group change listener success. listener = {}, duration = {} ms", (Object)listener.getClass().getName(), (Object)(System.currentTimeMillis() - startTime));
                }
                catch (Throwable t) {
                    LOGGER.error("[Config] failed to invoke config file group change listener. listener = {}, event = {}", new Object[]{listener.getClass().getName(), event, t});
                }
            });
        }
    }

    @Override
    public String toString() {
        return "DefaultConfigFileGroup{configFileMetadataList=" + this.configFileMetadataList + ", listeners=" + this.listeners + "} " + super.toString();
    }
}

