/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.internal;

import com.tencent.polaris.api.exception.UnimplementedException;
import com.tencent.polaris.api.plugin.configuration.ConfigFileGroupConnector;
import com.tencent.polaris.api.plugin.configuration.ConfigFileGroupMetadata;
import com.tencent.polaris.api.plugin.configuration.ConfigFileGroupResponse;
import com.tencent.polaris.configuration.client.internal.ExponentialRetryPolicy;
import com.tencent.polaris.configuration.client.internal.RetryPolicy;
import com.tencent.polaris.logging.LoggerFactory;
import org.slf4j.Logger;

public class RetryableConfigFileGroupConnector {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RetryableConfigFileGroupConnector.class);
    private static final int MAX_RETRY_TIMES = 3;
    private final ConfigFileGroupConnector rpcConnector;
    private final RetryPolicy retryPolicy;
    private final RetryableValidator retryableValidator;

    public RetryableConfigFileGroupConnector(ConfigFileGroupConnector rpcConnector, RetryableValidator retryableValidator) {
        this.rpcConnector = rpcConnector;
        this.retryableValidator = retryableValidator;
        this.retryPolicy = new ExponentialRetryPolicy(1L, 120L);
    }

    public ConfigFileGroupResponse GetConfigFileMetadataList(ConfigFileGroupMetadata configFileGroupMetadata, String revision) {
        int retryTimes = 0;
        while (retryTimes < 3) {
            try {
                ConfigFileGroupResponse response = this.rpcConnector.GetConfigFileMetadataList(configFileGroupMetadata, revision);
                if (!this.retryableValidator.shouldRetry(response)) {
                    this.retryPolicy.success();
                    return response;
                }
                LOGGER.error("[Config] get config file metadata list hits retry strategy. retry times = {}, namespace = {}, fileGroupName = {}, responseCod = {}", new Object[]{retryTimes, configFileGroupMetadata.getNamespace(), configFileGroupMetadata.getFileGroupName(), response.getCode()});
                this.retryPolicy.fail();
                ++retryTimes;
                this.retryPolicy.executeDelay();
            }
            catch (Throwable t) {
                if (t instanceof UnimplementedException) {
                    LOGGER.error("[Config] polaris server does not implement, please upgrade. ", t);
                    return null;
                }
                LOGGER.error("[Config] failed to get config file metadata list. retry times = {}, namespace = {}, fileGroupName = {}, exception = {}", new Object[]{retryTimes, configFileGroupMetadata.getNamespace(), configFileGroupMetadata.getFileGroupName(), t});
                this.retryPolicy.fail();
                ++retryTimes;
                this.retryPolicy.executeDelay();
            }
        }
        return null;
    }

    public static interface RetryableValidator {
        public boolean shouldRetry(ConfigFileGroupResponse var1);
    }
}

