/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.internal;

import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.configuration.ConfigFile;
import com.tencent.polaris.api.plugin.configuration.ConfigFileConnector;
import com.tencent.polaris.api.plugin.configuration.ConfigFileResponse;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.client.internal.AbstractConfigFileRepo;
import com.tencent.polaris.configuration.client.internal.ConfigFileLongPollingService;
import com.tencent.polaris.configuration.client.internal.ExponentialRetryPolicy;
import com.tencent.polaris.configuration.client.internal.RetryPolicy;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class RemoteConfigFileRepo
extends AbstractConfigFileRepo {
    private static final long INIT_VERSION = 0L;
    private static final ScheduledExecutorService pullExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("Configuration-Pull"));
    private final AtomicReference<ConfigFile> remoteConfigFile = new AtomicReference();
    private final AtomicLong notifiedVersion = new AtomicLong(0L);
    private final ConfigFileConnector configFileConnector;
    private final RetryPolicy retryPolicy = new ExponentialRetryPolicy(1L, 120L);

    public RemoteConfigFileRepo(SDKContext sdkContext, ConfigFileLongPollingService configFileLongPollingService, ConfigFileConnector configFileConnector, ConfigFileMetadata configFileMetadata) {
        super(sdkContext, configFileMetadata);
        if (configFileConnector != null) {
            this.configFileConnector = configFileConnector;
        } else {
            String configFileConnectorType = sdkContext.getConfig().getConfigFile().getServerConnector().getConnectorType();
            this.configFileConnector = (ConfigFileConnector)sdkContext.getExtensions().getPlugins().getPlugin(PluginTypes.CONFIG_FILE_CONNECTOR.getBaseType(), configFileConnectorType);
        }
        this.pull();
        this.addToLongPollingPool(configFileLongPollingService, configFileMetadata);
        this.startCheckVersionTask();
    }

    private void addToLongPollingPool(ConfigFileLongPollingService configFileLongPollingService, ConfigFileMetadata configFileMetadata) {
        ConfigFile configFile = this.remoteConfigFile.get();
        if (configFile == null) {
            configFile = new ConfigFile(configFileMetadata.getNamespace(), configFileMetadata.getFileGroup(), configFileMetadata.getFileName());
            configFile.setVersion(0L);
        }
        configFileLongPollingService.addConfigFile(this);
    }

    @Override
    public String getContent() {
        return this.remoteConfigFile.get() != null ? this.remoteConfigFile.get().getContent() : null;
    }

    public long getConfigFileVersion() {
        if (this.remoteConfigFile.get() == null) {
            return 0L;
        }
        return this.remoteConfigFile.get().getVersion();
    }

    @Override
    protected void doPull() {
        long startTime = System.currentTimeMillis();
        ConfigFile pullConfigFileReq = new ConfigFile(this.configFileMetadata.getNamespace(), this.configFileMetadata.getFileGroup(), this.configFileMetadata.getFileName());
        pullConfigFileReq.setVersion(this.notifiedVersion.get());
        LOGGER.info("[Config] start pull config file. config file = {}, version = {}", (Object)this.configFileMetadata, (Object)this.notifiedVersion.get());
        int retryTimes = 0;
        while (retryTimes < 3) {
            try {
                ConfigFileResponse response = this.configFileConnector.getConfigFile(pullConfigFileReq);
                this.retryPolicy.success();
                long pulledConfigFileVersion = response.getConfigFile() != null ? response.getConfigFile().getVersion() : -1L;
                LOGGER.info("[Config] pull config file finished. config file = {}, code = {}, version = {}, duration = {} ms", new Object[]{this.configFileMetadata, response.getCode(), pulledConfigFileVersion, System.currentTimeMillis() - startTime});
                if (response.getCode() == 200000) {
                    ConfigFile pulledConfigFile = response.getConfigFile();
                    if (this.remoteConfigFile.get() == null || pulledConfigFile.getVersion() >= this.remoteConfigFile.get().getVersion()) {
                        ConfigFile copiedConfigFile = this.deepCloneConfigFile(pulledConfigFile);
                        this.remoteConfigFile.set(copiedConfigFile);
                        this.fireChangeEvent(copiedConfigFile.getContent());
                    }
                    return;
                }
                if (response.getCode() == 400202) {
                    LOGGER.warn("[Config] config file not found, please check whether config file released. {}", (Object)this.configFileMetadata);
                    if (this.remoteConfigFile.get() != null) {
                        this.remoteConfigFile.set(null);
                        this.fireChangeEvent(null);
                    }
                    return;
                }
                LOGGER.error("[Config] pull response without expected code. retry times = {}, code = {}", (Object)retryTimes, (Object)response.getCode());
                this.retryPolicy.fail();
                ++retryTimes;
                this.retryPolicy.executeDelay();
            }
            catch (Throwable t) {
                LOGGER.error("[Config] failed to pull config file. retry times = {}", (Object)retryTimes, (Object)t);
                this.retryPolicy.fail();
                ++retryTimes;
                this.retryPolicy.executeDelay();
            }
        }
    }

    public void onLongPollNotified(long newVersion) {
        if (this.remoteConfigFile.get() != null && this.remoteConfigFile.get().getVersion() >= newVersion) {
            return;
        }
        this.notifiedVersion.set(newVersion);
        pullExecutorService.submit(this::pull);
    }

    private void startCheckVersionTask() {
        pullExecutorService.scheduleAtFixedRate(() -> {
            long pulledVersion;
            if (this.notifiedVersion == null || this.notifiedVersion.get() == 0L) {
                return;
            }
            long l = pulledVersion = this.remoteConfigFile.get() != null ? this.remoteConfigFile.get().getVersion() : 0L;
            if (this.notifiedVersion.get() > pulledVersion) {
                LOGGER.info("[Config] notified version greater than pulled version, will pull config file.file = {}, notified version = {}, pulled version = {}", new Object[]{this.getConfigFileMetadata(), this.notifiedVersion, pulledVersion});
                this.pull();
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    private ConfigFile deepCloneConfigFile(ConfigFile sourceConfigFile) {
        ConfigFile configFile = new ConfigFile(sourceConfigFile.getNamespace(), sourceConfigFile.getFileGroup(), sourceConfigFile.getFileName());
        configFile.setContent(sourceConfigFile.getContent());
        configFile.setVersion(sourceConfigFile.getVersion());
        configFile.setMd5(sourceConfigFile.getMd5());
        return configFile;
    }
}

