/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.tencent.polaris.api.config.configuration.ConfigFileConfig;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.configuration.api.core.ChangeType;
import com.tencent.polaris.configuration.api.core.ConfigFile;
import com.tencent.polaris.configuration.api.core.ConfigFileChangeEvent;
import com.tencent.polaris.configuration.api.core.ConfigFileChangeListener;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.client.internal.ConfigFileRepo;
import com.tencent.polaris.configuration.client.internal.ConfigFileRepoChangeListener;
import com.tencent.polaris.configuration.client.internal.DefaultConfigFileMetadata;
import com.tencent.polaris.logging.LoggerFactory;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;

public class DefaultConfigFile
extends DefaultConfigFileMetadata
implements ConfigFile,
ConfigFileRepoChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConfigFile.class);
    private static final Gson gson = new Gson();
    private static final String OBJECT_CACHE_KEY = "object";
    protected static ExecutorService notifyExecutorService = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("Configuration-Notify"));
    private final List<ConfigFileChangeListener> listeners = Lists.newCopyOnWriteArrayList();
    private final ConfigFileRepo configFileRepo;
    protected final ConfigFileConfig configFileConfig;
    private String content;
    private volatile Cache<String, Object> objectCache;
    private final AtomicLong cacheVersion;

    public DefaultConfigFile(String namespace, String fileGroup, String fileName, ConfigFileRepo configFileRepo, ConfigFileConfig configFileConfig) {
        super(namespace, fileGroup, fileName);
        this.configFileRepo = configFileRepo;
        this.configFileConfig = configFileConfig;
        this.cacheVersion = new AtomicLong();
        this.initialize();
    }

    protected void initialize() {
        this.content = this.configFileRepo.getContent();
        this.configFileRepo.addChangeListener(this);
    }

    public String getContent() {
        return this.content;
    }

    public <T> T asJson(Class<T> objectType, T defaultValue) {
        return this.convertToJson(OBJECT_CACHE_KEY, this.content, null, objectType, defaultValue);
    }

    public <T> T asJson(Type typeOfT, T defaultValue) {
        return this.convertToJson(OBJECT_CACHE_KEY, this.content, typeOfT, null, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T convertToJson(String key, String json, Type typeOfT, Class<T> clazz, T defaultValue) {
        if (StringUtils.isBlank((String)json)) {
            return defaultValue;
        }
        String type = null;
        try {
            Object result;
            this.createObjectCacheIfAbsent();
            Object cachedObject = this.objectCache.getIfPresent((Object)key);
            if (cachedObject != null) {
                return (T)cachedObject;
            }
            long currentCacheVersion = this.cacheVersion.get();
            if (clazz != null) {
                result = gson.fromJson(json, clazz);
                type = clazz.getTypeName();
            } else {
                result = gson.fromJson(json, typeOfT);
                type = typeOfT.getTypeName();
            }
            DefaultConfigFile defaultConfigFile = this;
            synchronized (defaultConfigFile) {
                if (result != null && currentCacheVersion == this.cacheVersion.get()) {
                    this.objectCache.put((Object)OBJECT_CACHE_KEY, result);
                }
            }
            return (T)result;
        }
        catch (Throwable t) {
            LOGGER.error("[Config] convert json file content to given class error. class type = {}", type, (Object)t);
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createObjectCacheIfAbsent() {
        if (this.objectCache == null) {
            DefaultConfigFile defaultConfigFile = this;
            synchronized (defaultConfigFile) {
                if (this.objectCache == null) {
                    this.objectCache = CacheBuilder.newBuilder().maximumSize((long)this.configFileConfig.getPropertiesValueCacheSize()).expireAfterAccess(this.configFileConfig.getPropertiesValueExpireTime(), TimeUnit.MINUTES).build();
                }
            }
        }
    }

    public boolean hasContent() {
        return !StringUtils.isBlank((String)this.content);
    }

    public void addChangeListener(ConfigFileChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeChangeListener(ConfigFileChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void onChange(ConfigFileMetadata configFileMetadata, String newContent) {
        String oldContent = this.content;
        this.content = newContent;
        ChangeType changeType = ChangeType.MODIFIED;
        if (oldContent == null) {
            changeType = ChangeType.ADDED;
        }
        if (newContent == null) {
            changeType = ChangeType.DELETED;
        }
        if (Objects.equals(oldContent, newContent)) {
            changeType = ChangeType.NOT_CHANGED;
        }
        if (this.objectCache != null) {
            this.objectCache.invalidateAll();
            this.cacheVersion.incrementAndGet();
        }
        this.fireChangeEvent(new ConfigFileChangeEvent(configFileMetadata, oldContent, newContent, changeType));
    }

    private void fireChangeEvent(ConfigFileChangeEvent event) {
        for (ConfigFileChangeListener listener : this.listeners) {
            notifyExecutorService.submit(() -> {
                try {
                    long startTime = System.currentTimeMillis();
                    listener.onChange(event);
                    LOGGER.info("[Config] invoke config file change listener success. listener = {}, duration = {} ms", (Object)listener.getClass().getName(), (Object)(System.currentTimeMillis() - startTime));
                }
                catch (Throwable t) {
                    LOGGER.error("[Config] failed to invoke config file change listener. listener = {}, event = {}", new Object[]{listener.getClass().getName(), event, t});
                }
            });
        }
    }
}

