/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.configuration.connector.polaris;

import com.google.gson.JsonObject;
import com.tencent.polaris.api.exception.ServerErrorResponseException;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.configuration.ConfigFile;
import com.tencent.polaris.api.plugin.configuration.ConfigFileResponse;
import com.tencent.polaris.plugins.configuration.connector.polaris.model.ConfigClientResponse;
import com.tencent.polaris.plugins.configuration.connector.polaris.rest.RestOperator;
import com.tencent.polaris.plugins.configuration.connector.polaris.rest.RestUtils;
import java.util.List;
import java.util.Objects;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenapiService {
    public static OpenapiService INSTANCE;
    private static final Logger LOG;
    private final String token;
    private final List<String> address;
    private final RestOperator restOperator = new RestOperator();

    private OpenapiService(InitContext ctx) {
        this.address = RestUtils.getAddress(ctx.getConfig().getConfigFile().getServerConnector());
        this.token = ctx.getConfig().getConfigFile().getServerConnector().getToken();
    }

    public static void initInstance(InitContext ctx) {
        INSTANCE = new OpenapiService(ctx);
    }

    public ConfigFileResponse getConfigFile(ConfigFile configFile) {
        ConfigClientResponse configClientResponse = this.getConfigFile(RestUtils.toConfigFileUrl(this.address), this.token, configFile);
        int code = Integer.parseInt(configClientResponse.getCode());
        if (code == 200000 || code == 400202 || code == 200001) {
            ConfigFile loadedConfigFile = RestUtils.transferFromDTO(configClientResponse.getConfigFile());
            return new ConfigFileResponse(code, configClientResponse.getInfo(), loadedConfigFile);
        }
        throw ServerErrorResponseException.build((int)code, (String)configClientResponse.getInfo());
    }

    public void createConfigFile(ConfigFile configFile) {
        this.createConfigFile(RestUtils.toConfigFileUrl(this.address), this.token, configFile);
    }

    public void updateConfigFile(ConfigFile configFile) {
        this.updateConfigFile(RestUtils.toConfigFileUrl(this.address), this.token, configFile);
    }

    public void releaseConfigFile(ConfigFile configFile) {
        this.releaseConfigFile(RestUtils.toReleaseConfigFileUrl(this.address), this.token, configFile);
    }

    public ConfigClientResponse getConfigFile(String url, String token, ConfigFile configFile) {
        url = Objects.requireNonNull(HttpUrl.parse((String)url)).newBuilder().addQueryParameter("name", configFile.getFileName()).addQueryParameter("group", configFile.getFileGroup()).addQueryParameter("namespace", configFile.getNamespace()).build().toString();
        return this.restOperator.doGet(url, token);
    }

    public ConfigClientResponse createConfigFile(String url, String token, ConfigFile configFile) {
        JsonObject params = RestUtils.getParams(configFile);
        params.addProperty("content", configFile.getContent());
        ConfigClientResponse response = this.restOperator.doPost(url, token, params.toString());
        LOG.info("[Polaris] creat configuration file success: Namespace={}, FileGroup={}, FileName={}, Content={}", new Object[]{configFile.getNamespace(), configFile.getFileGroup(), configFile.getFileName(), configFile.getContent()});
        return response;
    }

    public ConfigClientResponse updateConfigFile(String url, String token, ConfigFile configFile) {
        JsonObject params = RestUtils.getParams(configFile);
        params.addProperty("content", configFile.getContent());
        ConfigClientResponse response = this.restOperator.doPut(url, token, params.toString());
        LOG.info("[Polaris] update configuration file success: Namespace={}, FileGroup={}, FileName={}, Content={}", new Object[]{configFile.getNamespace(), configFile.getFileGroup(), configFile.getFileName(), configFile.getContent()});
        return response;
    }

    public ConfigClientResponse releaseConfigFile(String url, String token, ConfigFile configFile) {
        JsonObject params = new JsonObject();
        params.addProperty("fileName", configFile.getFileName());
        params.addProperty("group", configFile.getFileGroup());
        params.addProperty("namespace", configFile.getNamespace());
        ConfigClientResponse response = this.restOperator.doPost(url, token, params.toString());
        LOG.info("[Polaris] release configuration file success: Namespace={}, FileGroup={}, FileName={}", new Object[]{configFile.getNamespace(), configFile.getFileGroup(), configFile.getFileName()});
        return response;
    }

    static {
        LOG = LoggerFactory.getLogger(OpenapiService.class);
    }
}

