/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.configuration.connector.polaris.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tencent.polaris.api.exception.ServerErrorResponseException;
import com.tencent.polaris.plugins.configuration.connector.polaris.gson.DateNullAdapterFactory;
import com.tencent.polaris.plugins.configuration.connector.polaris.model.ConfigClientResponse;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestOperator {
    private static final Logger LOG = LoggerFactory.getLogger(RestOperator.class);
    private static final int DEFAULT_HTTP_TIMEOUT = 5000;
    private static final int DEFAULT_HTTP_READ_TIMEOUT = 10000;
    private static final Gson gson = new GsonBuilder().registerTypeAdapterFactory(new DateNullAdapterFactory()).create();
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(5000L, TimeUnit.MILLISECONDS).readTimeout(10000L, TimeUnit.MILLISECONDS).build();

    public ConfigClientResponse doGet(String url, String token) {
        LOG.debug("[Polaris] server send get request={}", (Object)url);
        Request request = new Request.Builder().url(url).addHeader("X-Polaris-Token", token).get().build();
        return this.doExecute(request);
    }

    public ConfigClientResponse doPost(String url, String token, String body) {
        LOG.debug("[Polaris] server send post request={}, body={}", (Object)url, (Object)body);
        Request request = new Request.Builder().url(url).addHeader("X-Polaris-Token", token).post(RequestBody.create((String)body, (MediaType)JSON)).build();
        return this.doExecute(request);
    }

    public ConfigClientResponse doPut(String url, String token, String body) {
        LOG.debug("[Polaris] server send put request={}, body={}", (Object)url, (Object)body);
        Request request = new Request.Builder().url(url).addHeader("X-Polaris-Token", token).put(RequestBody.create((String)body, (MediaType)JSON)).build();
        return this.doExecute(request);
    }

    private ConfigClientResponse doExecute(Request request) {
        ConfigClientResponse configClientResponse;
        try {
            Response response = this.client.newCall(request).execute();
            configClientResponse = (ConfigClientResponse)gson.fromJson(Objects.requireNonNull(response.body()).string(), ConfigClientResponse.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int code = Integer.parseInt(Objects.requireNonNull(configClientResponse).getCode());
        if (code != 200000) {
            LOG.error("[Polaris] server error to execute request={}, method={}, reason={}", new Object[]{request.url(), request.method(), configClientResponse.getInfo()});
            throw ServerErrorResponseException.build((int)code, (String)configClientResponse.getInfo());
        }
        return configClientResponse;
    }
}

