/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.configuration.connector.polaris;

import com.google.common.collect.Lists;
import com.google.protobuf.StringValue;
import com.tencent.polaris.api.config.global.ClusterType;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.RetriableException;
import com.tencent.polaris.api.exception.ServerErrorResponseException;
import com.tencent.polaris.api.plugin.configuration.ConfigFile;
import com.tencent.polaris.api.plugin.configuration.ConfigFileConnector;
import com.tencent.polaris.api.plugin.configuration.ConfigFileResponse;
import com.tencent.polaris.api.plugin.configuration.ConfigPublishFile;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.configuration.connector.polaris.AbstractPolarisConfigConnector;
import com.tencent.polaris.plugins.connector.grpc.Connection;
import com.tencent.polaris.plugins.connector.grpc.GrpcUtil;
import com.tencent.polaris.specification.api.v1.config.manage.ConfigFileProto;
import com.tencent.polaris.specification.api.v1.config.manage.ConfigFileResponseProto;
import com.tencent.polaris.specification.api.v1.config.manage.PolarisConfigGRPCGrpc;
import io.grpc.Channel;
import io.grpc.stub.AbstractStub;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;

public class PolarisConfigFileConnector
extends AbstractPolarisConfigConnector
implements ConfigFileConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisConfigFileConnector.class);
    private static final String OP_KEY_GET_CONFIG_FILE = "GetConfigFile";
    private static final String OP_KEY_CREATE_CONFIG_FILE = "CreateConfigFile";
    private static final String OP_KEY_UPDATE_CONFIG_FILE = "UpdateConfigFile";
    private static final String OP_KEY_RELEASE_CONFIG_FILE = "ReleaseConfigFile";

    public ConfigFileResponse getConfigFile(ConfigFile configFile) {
        Connection connection = null;
        try {
            connection = this.connectionManager.getConnection(OP_KEY_GET_CONFIG_FILE, ClusterType.SERVICE_CONFIG_CLUSTER);
            PolarisConfigGRPCGrpc.PolarisConfigGRPCBlockingStub stub = PolarisConfigGRPCGrpc.newBlockingStub((Channel)connection.getChannel());
            GrpcUtil.attachRequestHeader((AbstractStub)stub, (String)GrpcUtil.nextInstanceRegisterReqId());
            ConfigFileResponseProto.ConfigClientResponse response = stub.getConfigFile(configFile.toClientConfigFileInfo());
            LOGGER.debug("[Config] get getConfigFile response from remote. fileName = {}, response = {}", (Object)configFile.getFileName(), (Object)response);
            ConfigFileResponse configFileResponse = this.handleResponse(response);
            return configFileResponse;
        }
        catch (Throwable t) {
            if (connection != null) {
                connection.reportFail(ErrorCode.NETWORK_ERROR);
            }
            throw new RetriableException(ErrorCode.NETWORK_ERROR, String.format("failed to load config file. namespace = %s, group = %s, file = %s", configFile.getNamespace(), configFile.getFileGroup(), configFile.getFileName()), t);
        }
        finally {
            if (connection != null) {
                connection.release(OP_KEY_GET_CONFIG_FILE);
            }
        }
    }

    public ConfigFileResponse watchConfigFiles(List<ConfigFile> configFiles) {
        Connection connection = null;
        try {
            connection = this.connectionManager.getConnection(OP_KEY_GET_CONFIG_FILE, ClusterType.SERVICE_CONFIG_CLUSTER);
            PolarisConfigGRPCGrpc.PolarisConfigGRPCBlockingStub stub = PolarisConfigGRPCGrpc.newBlockingStub((Channel)connection.getChannel());
            GrpcUtil.attachRequestHeader((AbstractStub)stub, (String)GrpcUtil.nextInstanceRegisterReqId());
            LinkedList dtos = Lists.newLinkedList();
            for (ConfigFile configFile : configFiles) {
                dtos.add(configFile.toClientConfigFileInfo());
            }
            ConfigFileProto.ClientWatchConfigFileRequest request = ConfigFileProto.ClientWatchConfigFileRequest.newBuilder().addAllWatchFiles((Iterable)dtos).build();
            ConfigFileResponseProto.ConfigClientResponse response = stub.watchConfigFiles(request);
            ConfigFileResponse configFileResponse = this.handleResponse(response);
            return configFileResponse;
        }
        catch (Throwable t) {
            if (connection != null) {
                connection.reportFail(ErrorCode.NETWORK_ERROR);
            }
            throw new RetriableException(ErrorCode.NETWORK_ERROR, "[Config] failed to watch config file", t);
        }
        finally {
            if (connection != null) {
                connection.release(OP_KEY_GET_CONFIG_FILE);
            }
        }
    }

    public ConfigFileResponse createConfigFile(ConfigFile configFile) {
        Connection connection = null;
        try {
            connection = this.connectionManager.getConnection(OP_KEY_CREATE_CONFIG_FILE, ClusterType.SERVICE_CONFIG_CLUSTER);
            PolarisConfigGRPCGrpc.PolarisConfigGRPCBlockingStub stub = PolarisConfigGRPCGrpc.newBlockingStub((Channel)connection.getChannel());
            GrpcUtil.attachRequestHeader((AbstractStub)stub, (String)GrpcUtil.nextInstanceRegisterReqId());
            ConfigFileResponseProto.ConfigClientResponse response = stub.createConfigFile(this.transfer2ConfigFile(configFile));
            ConfigFileResponse configFileResponse = this.handleResponse(response);
            return configFileResponse;
        }
        catch (Throwable t) {
            if (connection != null) {
                connection.reportFail(ErrorCode.NETWORK_ERROR);
            }
            throw new RetriableException(ErrorCode.NETWORK_ERROR, String.format("failed to create config file. namespace = %s, group = %s, file = %s, content = %s", configFile.getNamespace(), configFile.getFileGroup(), configFile.getFileName(), configFile.getContent()), t);
        }
        finally {
            if (connection != null) {
                connection.release(OP_KEY_CREATE_CONFIG_FILE);
            }
        }
    }

    public ConfigFileResponse updateConfigFile(ConfigFile configFile) {
        Connection connection = null;
        try {
            connection = this.connectionManager.getConnection(OP_KEY_UPDATE_CONFIG_FILE, ClusterType.SERVICE_CONFIG_CLUSTER);
            PolarisConfigGRPCGrpc.PolarisConfigGRPCBlockingStub stub = PolarisConfigGRPCGrpc.newBlockingStub((Channel)connection.getChannel());
            GrpcUtil.attachRequestHeader((AbstractStub)stub, (String)GrpcUtil.nextInstanceRegisterReqId());
            ConfigFileResponseProto.ConfigClientResponse response = stub.updateConfigFile(this.transfer2ConfigFile(configFile));
            ConfigFileResponse configFileResponse = this.handleResponse(response);
            return configFileResponse;
        }
        catch (Throwable t) {
            if (connection != null) {
                connection.reportFail(ErrorCode.NETWORK_ERROR);
            }
            throw new RetriableException(ErrorCode.NETWORK_ERROR, String.format("failed to update config file. namespace = %s, group = %s, file = %s, content = %s", configFile.getNamespace(), configFile.getFileGroup(), configFile.getFileName(), configFile.getContent()), t);
        }
        finally {
            if (connection != null) {
                connection.release(OP_KEY_UPDATE_CONFIG_FILE);
            }
        }
    }

    public ConfigFileResponse releaseConfigFile(ConfigFile configFile) {
        Connection connection = null;
        try {
            connection = this.connectionManager.getConnection(OP_KEY_RELEASE_CONFIG_FILE, ClusterType.SERVICE_CONFIG_CLUSTER);
            PolarisConfigGRPCGrpc.PolarisConfigGRPCBlockingStub stub = PolarisConfigGRPCGrpc.newBlockingStub((Channel)connection.getChannel());
            GrpcUtil.attachRequestHeader((AbstractStub)stub, (String)GrpcUtil.nextInstanceRegisterReqId());
            ConfigFileResponseProto.ConfigClientResponse response = stub.publishConfigFile(this.transfer2ConfigFileRelease(configFile));
            ConfigFileResponse configFileResponse = this.handleResponse(response);
            return configFileResponse;
        }
        catch (Throwable t) {
            if (connection != null) {
                connection.reportFail(ErrorCode.NETWORK_ERROR);
            }
            throw new RetriableException(ErrorCode.NETWORK_ERROR, String.format("failed to release config file. namespace = %s, group = %s, file = %s", configFile.getNamespace(), configFile.getFileGroup(), configFile.getFileName()), t);
        }
        finally {
            if (connection != null) {
                connection.release(OP_KEY_RELEASE_CONFIG_FILE);
            }
        }
    }

    public ConfigFileResponse upsertAndPublishConfigFile(ConfigPublishFile request) {
        Connection connection = null;
        try {
            connection = this.connectionManager.getConnection(OP_KEY_RELEASE_CONFIG_FILE, ClusterType.SERVICE_CONFIG_CLUSTER);
            PolarisConfigGRPCGrpc.PolarisConfigGRPCBlockingStub stub = PolarisConfigGRPCGrpc.newBlockingStub((Channel)connection.getChannel());
            GrpcUtil.attachRequestHeader((AbstractStub)stub, (String)GrpcUtil.nextInstanceRegisterReqId());
            ConfigFileResponseProto.ConfigClientResponse response = stub.upsertAndPublishConfigFile(request.toSpec());
            ConfigFileResponse configFileResponse = this.handleResponse(response);
            return configFileResponse;
        }
        catch (Throwable t) {
            if (connection != null) {
                connection.reportFail(ErrorCode.NETWORK_ERROR);
            }
            throw new RetriableException(ErrorCode.NETWORK_ERROR, String.format("failed to upsert and publish config file. namespace = %s, group = %s, file = %s", request.getNamespace(), request.getFileGroup(), request.getFileName()), t);
        }
        finally {
            if (connection != null) {
                connection.release(OP_KEY_RELEASE_CONFIG_FILE);
            }
        }
    }

    @Override
    public String getName() {
        return "polaris";
    }

    private ConfigFile transferFromDTO(ConfigFileProto.ClientConfigFileInfo configFileDTO) {
        if (configFileDTO == null) {
            return null;
        }
        ConfigFile configFile = new ConfigFile(configFileDTO.getNamespace().getValue(), configFileDTO.getGroup().getValue(), configFileDTO.getFileName().getValue());
        configFile.setContent(configFileDTO.getContent().getValue());
        configFile.setMd5(configFileDTO.getMd5().getValue());
        configFile.setVersion(configFileDTO.getVersion().getValue());
        if (configFileDTO.getEncrypted().getValue()) {
            configFileDTO.getTagsList().forEach(tag -> {
                if (tag.getKey().getValue().equals("internal-datakey")) {
                    configFile.setDataKey(tag.getValue().getValue());
                }
            });
        }
        return configFile;
    }

    private ConfigFileProto.ConfigFile transfer2ConfigFile(ConfigFile configFile) {
        ConfigFileProto.ConfigFile.Builder builder = ConfigFileProto.ConfigFile.newBuilder();
        builder.setNamespace(StringValue.newBuilder().setValue(configFile.getNamespace()).build());
        builder.setGroup(StringValue.newBuilder().setValue(configFile.getFileGroup()).build());
        builder.setName(StringValue.newBuilder().setValue(configFile.getFileName()).build());
        builder.setContent(StringValue.newBuilder().setValue(configFile.getContent()).build());
        return builder.build();
    }

    private ConfigFileProto.ConfigFileRelease transfer2ConfigFileRelease(ConfigFile configFile) {
        ConfigFileProto.ConfigFileRelease.Builder builder = ConfigFileProto.ConfigFileRelease.newBuilder();
        builder.setNamespace(StringValue.newBuilder().setValue(configFile.getNamespace()).build());
        builder.setGroup(StringValue.newBuilder().setValue(configFile.getFileGroup()).build());
        builder.setFileName(StringValue.newBuilder().setValue(configFile.getFileName()).build());
        return builder.build();
    }

    private ConfigFileResponse handleResponse(ConfigFileResponseProto.ConfigClientResponse response) {
        int code = response.getCode().getValue();
        if (code == 200000 || code == 400202 || code == 200001) {
            ConfigFile loadedConfigFile = this.transferFromDTO(response.getConfigFile());
            return new ConfigFileResponse(code, response.getInfo().getValue(), loadedConfigFile);
        }
        throw ServerErrorResponseException.build((int)code, (String)response.getInfo().getValue());
    }
}

