/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.discovery.client.flow;

import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.compose.RouterChainGroup;
import com.tencent.polaris.api.plugin.loadbalance.LoadBalancer;
import com.tencent.polaris.api.plugin.route.RouteInfo;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.rpc.Criteria;
import com.tencent.polaris.api.rpc.InstancesResponse;
import com.tencent.polaris.api.rpc.ServiceRuleResponse;
import com.tencent.polaris.api.rpc.ServicesResponse;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.client.flow.BaseFlow;
import com.tencent.polaris.client.flow.FlowControlParam;
import com.tencent.polaris.client.flow.ResourcesResponse;
import com.tencent.polaris.discovery.client.flow.CommonInstancesRequest;
import com.tencent.polaris.discovery.client.flow.CommonRuleRequest;
import com.tencent.polaris.discovery.client.flow.CommonServicesRequest;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.Collection;
import org.slf4j.Logger;

public class SyncFlow {
    private static final Logger LOG = LoggerFactory.getLogger(SyncFlow.class);
    private Extensions extensions;

    public void init(Extensions extensions) {
        this.extensions = extensions;
    }

    public InstancesResponse commonSyncGetAllInstances(CommonInstancesRequest request) throws PolarisException {
        this.syncGetServiceInstances(request);
        ServiceInstances dstInstances = request.getDstInstances();
        return new InstancesResponse(dstInstances, "", null);
    }

    public InstancesResponse commonSyncGetInstances(CommonInstancesRequest request) throws PolarisException {
        this.syncGetServiceInstances(request);
        ServiceInstances dstInstances = request.getDstInstances();
        if (CollectionUtils.isEmpty((Collection)dstInstances.getInstances())) {
            return new InstancesResponse(dstInstances, "", null);
        }
        RouteInfo routeInfo = request.getRouteInfo();
        ServiceInstances routerInstances = BaseFlow.processServiceRouters((RouteInfo)routeInfo, (ServiceInstances)request.getDstInstances(), (RouterChainGroup)this.extensions.getConfigRouterChainGroup());
        return new InstancesResponse(routerInstances, routeInfo.getSubsetName(), routeInfo.getSubsetMetadata());
    }

    public InstancesResponse commonSyncGetOneInstance(CommonInstancesRequest request) throws PolarisException {
        this.syncGetServiceInstances(request);
        ServiceInstances dstInstances = request.getDstInstances();
        if (CollectionUtils.isEmpty((Collection)dstInstances.getInstances())) {
            return new InstancesResponse(dstInstances, "", null);
        }
        RouteInfo routeInfo = request.getRouteInfo();
        ServiceInstances routerInstances = BaseFlow.processServiceRouters((RouteInfo)routeInfo, (ServiceInstances)request.getDstInstances(), (RouterChainGroup)this.extensions.getConfigRouterChainGroup());
        LoadBalancer loadBalancer = this.extensions.getLoadBalancer();
        Instance instance = BaseFlow.processLoadBalance((LoadBalancer)loadBalancer, (Criteria)request.getCriteria(), (ServiceInstances)routerInstances);
        return new InstancesResponse(dstInstances, instance, routeInfo.getSubsetName(), routeInfo.getSubsetMetadata());
    }

    public ServiceRuleResponse commonSyncGetServiceRule(CommonRuleRequest request) throws PolarisException {
        ResourcesResponse resourcesResponse = BaseFlow.syncGetResources((Extensions)this.extensions, (boolean)false, (ServiceEventKeysProvider)request, (FlowControlParam)request);
        return new ServiceRuleResponse(resourcesResponse.getServiceRule(request.getSvcEventKey()));
    }

    private void syncGetServiceInstances(CommonInstancesRequest request) throws PolarisException {
        ResourcesResponse resourcesResponse = BaseFlow.syncGetResources((Extensions)this.extensions, (boolean)false, (ServiceEventKeysProvider)request, (FlowControlParam)request);
        request.setDstInstances(resourcesResponse.getServiceInstances(request.getDstInstanceEventKey()));
        if (null != request.getDstRuleEventKey()) {
            request.getRouteInfo().setDestRouteRule(resourcesResponse.getServiceRule(request.getDstRuleEventKey()));
        }
        if (null != request.getSrcRuleEventKey()) {
            request.getRouteInfo().setSourceRouteRule(resourcesResponse.getServiceRule(request.getSrcRuleEventKey()));
        }
    }

    public ServicesResponse commonSyncGetServices(CommonServicesRequest request) throws PolarisException {
        ResourcesResponse resourcesResponse = BaseFlow.syncGetResources((Extensions)this.extensions, (boolean)false, (ServiceEventKeysProvider)request, (FlowControlParam)request);
        return new ServicesResponse(resourcesResponse.getServices(request.getSvcEventKey()));
    }
}

