/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.discovery.client.flow;

import com.tencent.polaris.api.rpc.CommonProviderBaseEntity;
import com.tencent.polaris.api.rpc.InstanceDeregisterRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterRequest;
import com.tencent.polaris.client.api.SDKContext;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;

public class RegisterStateManager {
    private static final Map<String, Map<String, RegisterState>> REGISTER_STATES = new ConcurrentHashMap<String, Map<String, RegisterState>>();

    public static RegisterState putRegisterState(SDKContext sdkContext, InstanceRegisterRequest instanceRegisterRequest) {
        String registerStateKey = RegisterStateManager.buildRegisterStateKey((CommonProviderBaseEntity)instanceRegisterRequest);
        Map sdkRegisterStates = REGISTER_STATES.computeIfAbsent(sdkContext.getValueContext().getClientId(), clientId -> new ConcurrentHashMap());
        if (sdkRegisterStates.containsKey(registerStateKey)) {
            return null;
        }
        return sdkRegisterStates.computeIfAbsent(registerStateKey, unused -> {
            RegisterState registerState = new RegisterState();
            registerState.setInstanceRegisterRequest(instanceRegisterRequest);
            registerState.setFirstRegisterTime(System.currentTimeMillis());
            return registerState;
        });
    }

    public static void removeRegisterState(SDKContext sdkContext, InstanceDeregisterRequest instanceDeregisterRequest) {
        Optional.ofNullable(REGISTER_STATES.get(sdkContext.getValueContext().getClientId())).ifPresent(sdkRegisterStates -> {
            String registerStateKey = RegisterStateManager.buildRegisterStateKey((CommonProviderBaseEntity)instanceDeregisterRequest);
            Optional.ofNullable((RegisterState)sdkRegisterStates.remove(registerStateKey)).ifPresent(registerState -> registerState.getTaskFuture().cancel(false));
        });
    }

    public static void destroy(SDKContext sdkContext) {
        Optional.ofNullable(REGISTER_STATES.remove(sdkContext.getValueContext().getClientId())).ifPresent(sdkRegisterStates -> {
            for (RegisterState registerState : sdkRegisterStates.values()) {
                registerState.getTaskFuture().cancel(false);
            }
            sdkRegisterStates.clear();
        });
    }

    private static String buildRegisterStateKey(CommonProviderBaseEntity baseEntity) {
        return String.format("%s##%s##%s##%s", baseEntity.getNamespace(), baseEntity.getService(), baseEntity.getHost(), baseEntity.getPort());
    }

    public static final class RegisterState {
        private InstanceRegisterRequest instanceRegisterRequest;
        private long firstRegisterTime;
        private ScheduledFuture<?> taskFuture;
        private int heartbeatFailCounter = 0;

        public void incrementFailCount() {
            ++this.heartbeatFailCounter;
        }

        public int getHeartbeatFailCounter() {
            return this.heartbeatFailCounter;
        }

        public void resetFailCount() {
            this.heartbeatFailCounter = 0;
        }

        public InstanceRegisterRequest getInstanceRegisterRequest() {
            return this.instanceRegisterRequest;
        }

        public void setInstanceRegisterRequest(InstanceRegisterRequest instanceRegisterRequest) {
            this.instanceRegisterRequest = instanceRegisterRequest;
        }

        public long getFirstRegisterTime() {
            return this.firstRegisterTime;
        }

        public void setFirstRegisterTime(long firstRegisterTime) {
            this.firstRegisterTime = firstRegisterTime;
        }

        public ScheduledFuture<?> getTaskFuture() {
            return this.taskFuture;
        }

        public void setTaskFuture(ScheduledFuture<?> taskFuture) {
            this.taskFuture = taskFuture;
        }
    }
}

