/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.discovery.client.api;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.flow.DiscoveryFlow;
import com.tencent.polaris.api.rpc.GetAllInstancesRequest;
import com.tencent.polaris.api.rpc.GetHealthyInstancesRequest;
import com.tencent.polaris.api.rpc.GetInstancesRequest;
import com.tencent.polaris.api.rpc.GetOneInstanceRequest;
import com.tencent.polaris.api.rpc.GetServiceContractRequest;
import com.tencent.polaris.api.rpc.GetServiceRuleRequest;
import com.tencent.polaris.api.rpc.GetServicesRequest;
import com.tencent.polaris.api.rpc.InstancesFuture;
import com.tencent.polaris.api.rpc.InstancesResponse;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.api.rpc.ServiceRuleResponse;
import com.tencent.polaris.api.rpc.ServicesResponse;
import com.tencent.polaris.api.rpc.UnWatchServiceRequest;
import com.tencent.polaris.api.rpc.WatchInstancesRequest;
import com.tencent.polaris.api.rpc.WatchServiceRequest;
import com.tencent.polaris.api.rpc.WatchServiceResponse;
import com.tencent.polaris.client.api.BaseEngine;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.discovery.client.flow.AsyncFlow;
import com.tencent.polaris.discovery.client.flow.CommonInstancesRequest;
import com.tencent.polaris.discovery.client.flow.SyncFlow;
import com.tencent.polaris.discovery.client.util.Validator;

public class DefaultConsumerAPI
extends BaseEngine
implements ConsumerAPI {
    private final Configuration config;
    private DiscoveryFlow discoveryFlow;
    private final SyncFlow syncFlow = new SyncFlow();
    private final AsyncFlow asyncFlow = new AsyncFlow();

    public DefaultConsumerAPI(SDKContext context) {
        super(context);
        this.config = context.getConfig();
    }

    protected void subInit() throws PolarisException {
        this.discoveryFlow = (DiscoveryFlow)this.sdkContext.getOrInitFlow(DiscoveryFlow.class);
        this.syncFlow.init(this.sdkContext.getExtensions());
        this.asyncFlow.init(this.syncFlow);
    }

    public InstancesResponse getAllInstance(GetAllInstancesRequest req) throws PolarisException {
        return this.getAllInstances(req);
    }

    public InstancesResponse getAllInstances(GetAllInstancesRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetAllInstancesRequest(req);
        return this.discoveryFlow.getAllInstances(req);
    }

    public InstancesResponse getHealthyInstances(GetHealthyInstancesRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetHealthyInstancesRequest(req);
        return this.discoveryFlow.getHealthyInstances(req);
    }

    public InstancesResponse getOneInstance(GetOneInstanceRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetOneInstanceRequest(req);
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.syncFlow.commonSyncGetOneInstance(allRequest);
    }

    public InstancesResponse getInstances(GetInstancesRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetInstancesRequest(req);
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.syncFlow.commonSyncGetInstances(allRequest);
    }

    public InstancesFuture asyncGetOneInstance(GetOneInstanceRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetOneInstanceRequest(req);
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.asyncFlow.commonAsyncGetOneInstance(allRequest);
    }

    public InstancesFuture asyncGetInstances(GetInstancesRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetInstancesRequest(req);
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.asyncFlow.commonAsyncGetInstances(allRequest);
    }

    public InstancesFuture asyncGetAllInstances(GetAllInstancesRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetAllInstancesRequest(req);
        return this.discoveryFlow.asyncGetAllInstances(req);
    }

    public void updateServiceCallResult(ServiceCallResult req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateServiceCallResult(req);
        this.reportInvokeStat(req);
    }

    public ServiceRuleResponse getServiceRule(GetServiceRuleRequest request) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetServiceRuleRequest(request);
        return this.discoveryFlow.getServiceRule(request);
    }

    public ServicesResponse getServices(GetServicesRequest request) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        return this.discoveryFlow.getServices(request);
    }

    public WatchServiceResponse watchService(WatchServiceRequest request) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateWatchServiceRequest(request);
        InstancesResponse response = this.discoveryFlow.watchInstances(WatchInstancesRequest.builder().service(request.getService()).namespace(request.getNamespace()).listeners(request.getListeners()).build());
        return new WatchServiceResponse(response, true);
    }

    public boolean unWatchService(UnWatchServiceRequest request) {
        this.checkAvailable("ConsumerAPI");
        Validator.validateUnWatchServiceRequest(request);
        this.discoveryFlow.unWatchInstances(WatchInstancesRequest.builder().service(request.getService()).namespace(request.getNamespace()).listeners(request.getListeners()).build());
        return true;
    }

    public ServiceRuleResponse getServiceContract(GetServiceContractRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetServiceContractRequest(req);
        return this.discoveryFlow.getServiceContract(req);
    }
}

