/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.discovery.client.api;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.pojo.InstanceGauge;
import com.tencent.polaris.api.rpc.GetAllInstancesRequest;
import com.tencent.polaris.api.rpc.GetInstancesRequest;
import com.tencent.polaris.api.rpc.GetOneInstanceRequest;
import com.tencent.polaris.api.rpc.GetServiceRuleRequest;
import com.tencent.polaris.api.rpc.InstancesFuture;
import com.tencent.polaris.api.rpc.InstancesResponse;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.api.rpc.ServiceRuleResponse;
import com.tencent.polaris.client.api.BaseEngine;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.api.ServiceCallResultListener;
import com.tencent.polaris.discovery.client.flow.AsyncFlow;
import com.tencent.polaris.discovery.client.flow.CommonInstancesRequest;
import com.tencent.polaris.discovery.client.flow.CommonRuleRequest;
import com.tencent.polaris.discovery.client.flow.SyncFlow;
import com.tencent.polaris.discovery.client.util.Validator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConsumerAPI
extends BaseEngine
implements ConsumerAPI {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConsumerAPI.class);
    private final Configuration config;
    private final SyncFlow syncFlow = new SyncFlow();
    private final AsyncFlow asyncFlow = new AsyncFlow();
    private List<ServiceCallResultListener> serviceCallResultListeners;

    public DefaultConsumerAPI(SDKContext context) {
        super(context);
        this.config = context.getConfig();
        this.syncFlow.init(context.getExtensions());
        this.asyncFlow.init(this.syncFlow);
    }

    protected void subInit() {
        this.serviceCallResultListeners = ServiceCallResultListener.getServiceCallResultListeners((SDKContext)this.sdkContext);
        this.sdkContext.registerDestroyHook(new Destroyable(){

            protected void doDestroy() {
                if (null != DefaultConsumerAPI.this.serviceCallResultListeners) {
                    for (ServiceCallResultListener listener : DefaultConsumerAPI.this.serviceCallResultListeners) {
                        listener.destroy();
                    }
                }
            }
        });
    }

    public InstancesResponse getAllInstance(GetAllInstancesRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetAllInstancesRequest(req);
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.syncFlow.commonSyncGetAllInstances(allRequest);
    }

    public InstancesResponse getOneInstance(GetOneInstanceRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetOneInstanceRequest(req);
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.syncFlow.commonSyncGetOneInstance(allRequest);
    }

    public InstancesResponse getInstances(GetInstancesRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetInstancesRequest(req);
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.syncFlow.commonSyncGetInstances(allRequest);
    }

    public InstancesFuture asyncGetOneInstance(GetOneInstanceRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetOneInstanceRequest(req);
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.asyncFlow.commonAsyncGetOneInstance(allRequest);
    }

    public InstancesFuture asyncGetInstances(GetInstancesRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetInstancesRequest(req);
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.asyncFlow.commonAsyncGetInstances(allRequest);
    }

    public InstancesFuture asyncGetAllInstances(GetAllInstancesRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetAllInstancesRequest(req);
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.asyncFlow.commonAsyncGetAllInstances(allRequest);
    }

    public void updateServiceCallResult(ServiceCallResult req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateServiceCallResult(req);
        for (ServiceCallResultListener listener : this.serviceCallResultListeners) {
            listener.onServiceCallResult((InstanceGauge)req);
        }
    }

    public ServiceRuleResponse getServiceRule(GetServiceRuleRequest request) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetServiceRuleRequest(request);
        CommonRuleRequest commonRuleRequest = new CommonRuleRequest(request, this.config);
        return this.syncFlow.commonSyncGetServiceRule(commonRuleRequest);
    }
}

