/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.discovery.client.api;

import com.tencent.polaris.api.core.ProviderAPI;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.exception.RetriableException;
import com.tencent.polaris.api.plugin.server.CommonProviderResponse;
import com.tencent.polaris.api.plugin.server.ServerConnector;
import com.tencent.polaris.api.rpc.InstanceDeregisterRequest;
import com.tencent.polaris.api.rpc.InstanceHeartbeatRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterResponse;
import com.tencent.polaris.api.rpc.RequestBaseEntity;
import com.tencent.polaris.client.api.BaseEngine;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.util.Utils;
import com.tencent.polaris.discovery.client.util.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProviderAPI
extends BaseEngine
implements ProviderAPI {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultProviderAPI.class);
    private ServerConnector serverConnector;

    public DefaultProviderAPI(SDKContext sdkContext) {
        super(sdkContext);
    }

    protected void subInit() {
        this.serverConnector = this.sdkContext.getExtensions().getServerConnector();
    }

    public InstanceRegisterResponse register(InstanceRegisterRequest req) throws PolarisException {
        this.checkAvailable("ProviderAPI");
        Validator.validateInstanceRegisterRequest(req);
        long retryInterval = this.sdkContext.getConfig().getGlobal().getAPI().getRetryInterval();
        long timeout = this.getTimeout((RequestBaseEntity)req);
        while (timeout > 0L) {
            long start = System.currentTimeMillis();
            try {
                CommonProviderResponse response = this.serverConnector.registerInstance(req.getRequest());
                LOG.info("register {}/{} instance {} succ", new Object[]{req.getNamespace(), req.getService(), response.getInstanceID()});
                InstanceRegisterResponse instanceRegisterResponse = new InstanceRegisterResponse(response.getInstanceID(), response.isExists());
                return instanceRegisterResponse;
            }
            catch (PolarisException e) {
                if (e instanceof RetriableException) {
                    LOG.warn("instance register request error, retrying.", (Throwable)e);
                    Utils.sleepUninterrupted((long)retryInterval);
                    continue;
                }
                throw e;
            }
            finally {
                timeout -= System.currentTimeMillis() - start;
            }
        }
        throw new PolarisException(ErrorCode.API_TIMEOUT, "instance register request timeout.");
    }

    public void deRegister(InstanceDeregisterRequest req) throws PolarisException {
        this.checkAvailable("ProviderAPI");
        Validator.validateInstanceDeregisterRequest(req);
        long retryInterval = this.sdkContext.getConfig().getGlobal().getAPI().getRetryInterval();
        long timeout = this.getTimeout((RequestBaseEntity)req);
        while (timeout > 0L) {
            long start = System.currentTimeMillis();
            try {
                this.serverConnector.deregisterInstance(req.getRequest());
                LOG.info("deregister instance {} succ", (Object)req);
                return;
            }
            catch (PolarisException e) {
                if (e instanceof RetriableException) {
                    LOG.warn("instance deregister request error, retrying.", (Throwable)e);
                    Utils.sleepUninterrupted((long)retryInterval);
                    continue;
                }
                throw e;
            }
            finally {
                timeout -= System.currentTimeMillis() - start;
            }
        }
        throw new PolarisException(ErrorCode.API_TIMEOUT, "instance deregister request timeout.");
    }

    public void heartbeat(InstanceHeartbeatRequest req) throws PolarisException {
        this.checkAvailable("ProviderAPI");
        Validator.validateHeartbeatRequest(req);
        long timeout = this.getTimeout((RequestBaseEntity)req);
        long retryInterval = this.sdkContext.getConfig().getGlobal().getAPI().getRetryInterval();
        while (timeout > 0L) {
            long start = System.currentTimeMillis();
            try {
                this.serverConnector.heartbeat(req.getRequest());
                return;
            }
            catch (PolarisException e) {
                if (e instanceof RetriableException) {
                    LOG.warn("heartbeat request error, retrying.", (Throwable)e);
                    Utils.sleepUninterrupted((long)retryInterval);
                    continue;
                }
                throw e;
            }
            finally {
                timeout -= System.currentTimeMillis() - start;
            }
        }
        throw new PolarisException(ErrorCode.API_TIMEOUT, "heartbeat request timeout.");
    }
}

