/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.discovery.client.api;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.rpc.GetAllInstancesRequest;
import com.tencent.polaris.api.rpc.GetInstancesRequest;
import com.tencent.polaris.api.rpc.GetOneInstanceRequest;
import com.tencent.polaris.api.rpc.GetServiceRuleRequest;
import com.tencent.polaris.api.rpc.GetServicesRequest;
import com.tencent.polaris.api.rpc.InstancesFuture;
import com.tencent.polaris.api.rpc.InstancesResponse;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.api.rpc.ServiceRuleResponse;
import com.tencent.polaris.api.rpc.ServicesResponse;
import com.tencent.polaris.api.rpc.UnWatchServiceRequest;
import com.tencent.polaris.api.rpc.WatchServiceRequest;
import com.tencent.polaris.api.rpc.WatchServiceResponse;
import com.tencent.polaris.client.api.BaseEngine;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.discovery.client.flow.AsyncFlow;
import com.tencent.polaris.discovery.client.flow.CommonInstancesRequest;
import com.tencent.polaris.discovery.client.flow.CommonRuleRequest;
import com.tencent.polaris.discovery.client.flow.CommonServicesRequest;
import com.tencent.polaris.discovery.client.flow.CommonUnWatchServiceRequest;
import com.tencent.polaris.discovery.client.flow.CommonWatchServiceRequest;
import com.tencent.polaris.discovery.client.flow.SyncFlow;
import com.tencent.polaris.discovery.client.flow.WatchFlow;
import com.tencent.polaris.discovery.client.util.Validator;
import com.tencent.polaris.logging.LoggerFactory;
import org.slf4j.Logger;

public class DefaultConsumerAPI
extends BaseEngine
implements ConsumerAPI {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConsumerAPI.class);
    private final Configuration config;
    private final SyncFlow syncFlow = new SyncFlow();
    private final AsyncFlow asyncFlow = new AsyncFlow();
    private final WatchFlow watchFlow = new WatchFlow();

    public DefaultConsumerAPI(SDKContext context) {
        super(context);
        this.config = context.getConfig();
        this.syncFlow.init(context.getExtensions());
        this.asyncFlow.init(this.syncFlow);
        this.watchFlow.init(context.getExtensions(), this.syncFlow);
    }

    protected void subInit() throws PolarisException {
    }

    public InstancesResponse getAllInstance(GetAllInstancesRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetAllInstancesRequest(req);
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.syncFlow.commonSyncGetAllInstances(allRequest);
    }

    public InstancesResponse getOneInstance(GetOneInstanceRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetOneInstanceRequest(req);
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.syncFlow.commonSyncGetOneInstance(allRequest);
    }

    public InstancesResponse getInstances(GetInstancesRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetInstancesRequest(req);
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.syncFlow.commonSyncGetInstances(allRequest);
    }

    public InstancesFuture asyncGetOneInstance(GetOneInstanceRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetOneInstanceRequest(req);
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.asyncFlow.commonAsyncGetOneInstance(allRequest);
    }

    public InstancesFuture asyncGetInstances(GetInstancesRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetInstancesRequest(req);
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.asyncFlow.commonAsyncGetInstances(allRequest);
    }

    public InstancesFuture asyncGetAllInstances(GetAllInstancesRequest req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetAllInstancesRequest(req);
        CommonInstancesRequest allRequest = new CommonInstancesRequest(req, this.config);
        return this.asyncFlow.commonAsyncGetAllInstances(allRequest);
    }

    public void updateServiceCallResult(ServiceCallResult req) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateServiceCallResult(req);
        this.reportInvokeStat(req);
    }

    public ServiceRuleResponse getServiceRule(GetServiceRuleRequest request) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateGetServiceRuleRequest(request);
        CommonRuleRequest commonRuleRequest = new CommonRuleRequest(request, this.config);
        return this.syncFlow.commonSyncGetServiceRule(commonRuleRequest);
    }

    public ServicesResponse getServices(GetServicesRequest request) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        CommonServicesRequest commonServicesRequest = new CommonServicesRequest(request, this.config);
        return this.syncFlow.commonSyncGetServices(commonServicesRequest);
    }

    public WatchServiceResponse watchService(WatchServiceRequest request) throws PolarisException {
        this.checkAvailable("ConsumerAPI");
        Validator.validateWatchServiceRequest(request);
        CommonWatchServiceRequest watchServiceRequest = new CommonWatchServiceRequest(request, new CommonInstancesRequest(GetAllInstancesRequest.builder().service(request.getService()).namespace(request.getNamespace()).build(), this.config));
        return this.watchFlow.commonWatchService(watchServiceRequest);
    }

    public boolean unWatchService(UnWatchServiceRequest request) {
        this.checkAvailable("ConsumerAPI");
        Validator.validateUnWatchServiceRequest(request);
        CommonUnWatchServiceRequest unWatchServiceRequest = new CommonUnWatchServiceRequest(request);
        return this.watchFlow.commonUnWatchService(unWatchServiceRequest).isSuccess();
    }
}

