/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.discovery.client.flow;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.plugin.route.RouteInfo;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import com.tencent.polaris.api.rpc.Criteria;
import com.tencent.polaris.api.rpc.GetAllInstancesRequest;
import com.tencent.polaris.api.rpc.GetHealthyInstancesRequest;
import com.tencent.polaris.api.rpc.GetInstancesRequest;
import com.tencent.polaris.api.rpc.GetOneInstanceRequest;
import com.tencent.polaris.api.rpc.RequestBaseEntity;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.flow.BaseFlow;
import com.tencent.polaris.client.flow.FlowControlParam;
import java.util.HashSet;
import java.util.Set;

public class CommonInstancesRequest
implements ServiceEventKeysProvider,
FlowControlParam {
    private final ServiceEventKey srcRuleEventKey;
    private final ServiceEventKey dstInstanceEventKey;
    private final ServiceEventKey dstRuleEventKey;
    private final RouteInfo routeInfo;
    private ServiceInstances dstInstances;
    private final Criteria criteria;
    private final Set<ServiceEventKey> svcEventKeys = new HashSet<ServiceEventKey>();
    private long timeoutMs;
    private int maxRetry;
    private long retryIntervalMs;

    public CommonInstancesRequest(GetAllInstancesRequest request, Configuration configuration) {
        ServiceKey dstSvcKey = new ServiceKey(request.getNamespace(), request.getService());
        this.dstInstanceEventKey = new ServiceEventKey(dstSvcKey, ServiceEventKey.EventType.INSTANCE);
        this.svcEventKeys.add(this.dstInstanceEventKey);
        this.dstRuleEventKey = null;
        this.srcRuleEventKey = null;
        this.routeInfo = null;
        this.criteria = null;
        BaseFlow.buildFlowControlParam((RequestBaseEntity)request, (Configuration)configuration, (FlowControlParam)this);
    }

    public CommonInstancesRequest(GetHealthyInstancesRequest request, Configuration configuration) {
        ServiceKey dstSvcKey = new ServiceKey(request.getNamespace(), request.getService());
        this.dstInstanceEventKey = new ServiceEventKey(dstSvcKey, ServiceEventKey.EventType.INSTANCE);
        this.svcEventKeys.add(this.dstInstanceEventKey);
        this.dstRuleEventKey = new ServiceEventKey(dstSvcKey, ServiceEventKey.EventType.ROUTING);
        this.svcEventKeys.add(this.dstRuleEventKey);
        this.srcRuleEventKey = null;
        ServiceInfo dstServiceInfo = new ServiceInfo();
        dstServiceInfo.setNamespace(request.getNamespace());
        dstServiceInfo.setService(request.getService());
        dstServiceInfo.setMetadata(request.getMetadata());
        this.routeInfo = new RouteInfo(null, (ServiceMetadata)dstServiceInfo, null);
        this.routeInfo.setIncludeUnhealthyInstances(false);
        this.criteria = null;
        this.routeInfo.disableRouter("metadataRouter");
        this.routeInfo.disableRouter("ruleBasedRouter");
        this.routeInfo.disableRouter("nearbyBasedRouter");
        this.routeInfo.disableRouter("setRouter");
        this.routeInfo.disableRouter("canaryRouter");
        BaseFlow.buildFlowControlParam((RequestBaseEntity)request, (Configuration)configuration, (FlowControlParam)this);
    }

    public CommonInstancesRequest(GetOneInstanceRequest request, Configuration configuration) {
        ServiceKey dstSvcKey = new ServiceKey(request.getNamespace(), request.getService());
        this.dstInstanceEventKey = new ServiceEventKey(dstSvcKey, ServiceEventKey.EventType.INSTANCE);
        this.svcEventKeys.add(this.dstInstanceEventKey);
        this.dstRuleEventKey = new ServiceEventKey(dstSvcKey, ServiceEventKey.EventType.ROUTING);
        this.svcEventKeys.add(this.dstRuleEventKey);
        ServiceMetadata srcServiceInfo = request.getServiceInfo();
        if (null != srcServiceInfo && !StringUtils.isBlank((String)srcServiceInfo.getNamespace()) && !StringUtils.isBlank((String)srcServiceInfo.getService())) {
            ServiceKey srcService = new ServiceKey(srcServiceInfo.getNamespace(), srcServiceInfo.getService());
            this.srcRuleEventKey = new ServiceEventKey(srcService, ServiceEventKey.EventType.ROUTING);
            this.svcEventKeys.add(this.srcRuleEventKey);
        } else {
            this.srcRuleEventKey = null;
        }
        ServiceInfo dstServiceInfo = new ServiceInfo();
        dstServiceInfo.setNamespace(request.getNamespace());
        dstServiceInfo.setService(request.getService());
        dstServiceInfo.setMetadata(request.getMetadata());
        this.routeInfo = new RouteInfo(srcServiceInfo, (ServiceMetadata)dstServiceInfo, request.getMethod());
        this.routeInfo.setCanary(request.getCanary());
        this.routeInfo.setMetadataFailoverType(request.getMetadataFailoverType());
        this.criteria = request.getCriteria();
        BaseFlow.buildFlowControlParam((RequestBaseEntity)request, (Configuration)configuration, (FlowControlParam)this);
    }

    public CommonInstancesRequest(GetInstancesRequest request, Configuration configuration) {
        ServiceKey dstSvcKey = new ServiceKey(request.getNamespace(), request.getService());
        this.dstInstanceEventKey = new ServiceEventKey(dstSvcKey, ServiceEventKey.EventType.INSTANCE);
        this.svcEventKeys.add(this.dstInstanceEventKey);
        this.dstRuleEventKey = new ServiceEventKey(dstSvcKey, ServiceEventKey.EventType.ROUTING);
        this.svcEventKeys.add(this.dstRuleEventKey);
        ServiceMetadata srcServiceInfo = request.getServiceInfo();
        if (null != srcServiceInfo && StringUtils.isNotBlank((String)srcServiceInfo.getNamespace()) && StringUtils.isNotBlank((String)srcServiceInfo.getService())) {
            ServiceKey srcService = new ServiceKey(srcServiceInfo.getNamespace(), srcServiceInfo.getService());
            this.srcRuleEventKey = new ServiceEventKey(srcService, ServiceEventKey.EventType.ROUTING);
            this.svcEventKeys.add(this.srcRuleEventKey);
        } else {
            this.srcRuleEventKey = null;
        }
        ServiceInfo dstServiceInfo = new ServiceInfo();
        dstServiceInfo.setNamespace(request.getNamespace());
        dstServiceInfo.setService(request.getService());
        dstServiceInfo.setMetadata(request.getMetadata());
        this.routeInfo = new RouteInfo(srcServiceInfo, (ServiceMetadata)dstServiceInfo, request.getMethod());
        this.routeInfo.setIncludeCircuitBreakInstances(request.isIncludeCircuitBreak());
        this.routeInfo.setIncludeUnhealthyInstances(request.isIncludeUnhealthy());
        this.routeInfo.setCanary(request.getCanary());
        this.routeInfo.setMetadataFailoverType(request.getMetadataFailoverType());
        this.criteria = null;
        BaseFlow.buildFlowControlParam((RequestBaseEntity)request, (Configuration)configuration, (FlowControlParam)this);
    }

    public ServiceEventKey getSrcRuleEventKey() {
        return this.srcRuleEventKey;
    }

    public ServiceEventKey getDstInstanceEventKey() {
        return this.dstInstanceEventKey;
    }

    public ServiceEventKey getDstRuleEventKey() {
        return this.dstRuleEventKey;
    }

    public RouteInfo getRouteInfo() {
        return this.routeInfo;
    }

    public ServiceInstances getDstInstances() {
        return this.dstInstances;
    }

    public void setDstInstances(ServiceInstances dstInstances) {
        this.dstInstances = dstInstances;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public boolean isUseCache() {
        return false;
    }

    public Set<ServiceEventKey> getSvcEventKeys() {
        return this.svcEventKeys;
    }

    public ServiceEventKey getSvcEventKey() {
        return null;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public void setTimeoutMs(long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public long getRetryIntervalMs() {
        return this.retryIntervalMs;
    }

    public void setRetryIntervalMs(long retryIntervalMs) {
        this.retryIntervalMs = retryIntervalMs;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public void setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
    }
}

