/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.discovery.client.flow;

import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.listener.ServiceListener;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.registry.AbstractResourceEventListener;
import com.tencent.polaris.api.plugin.registry.ResourceEventListener;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceChangeEvent;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.rpc.InstancesResponse;
import com.tencent.polaris.api.rpc.WatchServiceResponse;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.client.pojo.ServiceInstancesByProto;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.client.util.Utils;
import com.tencent.polaris.discovery.client.flow.CommonUnWatchServiceRequest;
import com.tencent.polaris.discovery.client.flow.CommonWatchServiceRequest;
import com.tencent.polaris.discovery.client.flow.SyncFlow;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.slf4j.Logger;

public class WatchFlow {
    private static final Logger LOG = LoggerFactory.getLogger(SyncFlow.class);
    private Extensions extensions;
    private SyncFlow syncFlow;
    private DispatchExecutor executor;
    private final AtomicBoolean initialize = new AtomicBoolean(false);
    private static final Map<ServiceKey, Set<ServiceListener>> watchers = new ConcurrentHashMap<ServiceKey, Set<ServiceListener>>();

    public void init(Extensions extensions, SyncFlow syncFlow) {
        this.extensions = extensions;
        this.syncFlow = syncFlow;
    }

    public WatchServiceResponse commonWatchService(CommonWatchServiceRequest request) throws PolarisException {
        this.initFlow();
        ServiceKey serviceKey = request.getSvcEventKey().getServiceKey();
        InstancesResponse response = this.syncFlow.commonSyncGetAllInstances(request.getAllRequest());
        watchers.computeIfAbsent(request.getSvcEventKey().getServiceKey(), key -> Collections.synchronizedSet(new HashSet()));
        boolean result = watchers.get(serviceKey).addAll(request.getWatchServiceRequest().getListeners());
        return new WatchServiceResponse(response, result);
    }

    public WatchServiceResponse commonUnWatchService(CommonUnWatchServiceRequest request) throws PolarisException {
        this.initFlow();
        boolean result = true;
        Set<ServiceListener> listeners = watchers.get(request.getSvcEventKey().getServiceKey());
        if (request.getRequest().isRemoveAll()) {
            watchers.remove(request.getSvcEventKey().getServiceKey());
        } else if (CollectionUtils.isNotEmpty(listeners)) {
            result = listeners.removeAll(request.getRequest().getListeners());
        }
        return new WatchServiceResponse(null, result);
    }

    private void initFlow() {
        if (this.initialize.compareAndSet(false, true)) {
            this.extensions.getLocalRegistry().registerResourceListener((ResourceEventListener)new InstanceChangeListener());
            this.executor = new DispatchExecutor(this.extensions.getConfiguration().getConsumer().getSubscribe().getCallbackConcurrency());
        }
    }

    private static class DispatchExecutor {
        private final Executor[] executors;

        public DispatchExecutor(int nThread) {
            if (nThread < 1) {
                nThread = 1;
            }
            this.executors = new Executor[nThread];
            for (int i = 0; i < nThread; ++i) {
                this.executors[i] = Executors.newFixedThreadPool(1, (ThreadFactory)new NamedThreadFactory("service-watch-dispatch" + i));
            }
        }

        public void execute(ServiceKey serviceKey, Runnable command) {
            int code = serviceKey.hashCode();
            Executor executor = this.executors[code % this.executors.length];
            executor.execute(command);
        }
    }

    private class InstanceChangeListener
    extends AbstractResourceEventListener {
        private final BiConsumer<ServiceChangeEvent, ServiceListener> consumer = (event, listener) -> WatchFlow.this.executor.execute(event.getServiceKey(), () -> listener.onEvent(event));

        private InstanceChangeListener() {
        }

        public void onResourceUpdated(ServiceEventKey svcEventKey, RegistryCacheValue oldValue, RegistryCacheValue newValue) {
            if (newValue.getEventType() != ServiceEventKey.EventType.INSTANCE) {
                return;
            }
            if (oldValue instanceof ServiceInstancesByProto && newValue instanceof ServiceInstancesByProto) {
                LOG.debug("receive service={} change event", (Object)svcEventKey);
                ServiceInstancesByProto oldIns = (ServiceInstancesByProto)oldValue;
                ServiceInstancesByProto newIns = (ServiceInstancesByProto)newValue;
                ServiceChangeEvent event = ServiceChangeEvent.builder().serviceKey(svcEventKey.getServiceKey()).addInstances(Utils.checkAddInstances((ServiceInstancesByProto)oldIns, (ServiceInstancesByProto)newIns)).updateInstances(Utils.checkUpdateInstances((ServiceInstancesByProto)oldIns, (ServiceInstancesByProto)newIns)).deleteInstances(Utils.checkDeleteInstances((ServiceInstancesByProto)oldIns, (ServiceInstancesByProto)newIns)).allInstances(newIns.getInstances()).build();
                Set<ServiceListener> listeners = watchers.getOrDefault(svcEventKey.getServiceKey(), Collections.emptySet());
                listeners.forEach(serviceListener -> this.consumer.accept(event, (ServiceListener)serviceListener));
            }
        }
    }
}

