/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.api;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.core.ProviderAPI;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.discovery.client.api.DefaultConsumerAPI;
import com.tencent.polaris.discovery.client.api.DefaultProviderAPI;
import com.tencent.polaris.factory.ConfigAPIFactory;
import java.io.InputStream;

public class DiscoveryAPIFactory {
    public static ConsumerAPI createConsumerAPI() throws PolarisException {
        Configuration configuration = ConfigAPIFactory.defaultConfig();
        return DiscoveryAPIFactory.createConsumerAPIByConfig(configuration);
    }

    public static ConsumerAPI createConsumerAPIByContext(SDKContext context) throws PolarisException {
        DefaultConsumerAPI defaultValue = new DefaultConsumerAPI(context);
        defaultValue.init();
        return defaultValue;
    }

    public static ConsumerAPI createConsumerAPIByFile(InputStream configStream) throws PolarisException {
        Configuration configuration = ConfigAPIFactory.loadConfig((InputStream)configStream);
        return DiscoveryAPIFactory.createConsumerAPIByConfig(configuration);
    }

    public static ConsumerAPI createConsumerAPIByConfig(Configuration config) throws PolarisException {
        SDKContext context = SDKContext.initContextByConfig((Configuration)config);
        return DiscoveryAPIFactory.createConsumerAPIByContext(context);
    }

    public static ProviderAPI createProviderAPI() throws PolarisException {
        Configuration configuration = ConfigAPIFactory.defaultConfig();
        return DiscoveryAPIFactory.createProviderAPIByConfig(configuration);
    }

    public static ProviderAPI createProviderAPIByContext(SDKContext context) throws PolarisException {
        DefaultProviderAPI defaultValue = new DefaultProviderAPI(context);
        defaultValue.init();
        return defaultValue;
    }

    public static ProviderAPI createProviderAPIByFile(InputStream configStream) throws PolarisException {
        Configuration configuration = ConfigAPIFactory.loadConfig((InputStream)configStream);
        return DiscoveryAPIFactory.createProviderAPIByConfig(configuration);
    }

    public static ProviderAPI createProviderAPIByConfig(Configuration config) throws PolarisException {
        SDKContext context = SDKContext.initContextByConfig((Configuration)config);
        return DiscoveryAPIFactory.createProviderAPIByContext(context);
    }
}

