/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.logging.log4j2;

import com.tencent.polaris.logging.AbstractPolarisLogging;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;

public class Log4j2PolarisLogging
extends AbstractPolarisLogging {
    private static final String LOG4J2_LOCATION = "classpath:polaris-log4j2.xml";
    private static final String FILE_PROTOCOL = "file";
    private final String location = this.getLocation("classpath:polaris-log4j2.xml");

    @Override
    public void loadConfiguration() {
        if (null == this.location || this.location.trim().length() == 0) {
            return;
        }
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration contextConfiguration = loggerContext.getConfiguration();
        Configuration configuration = this.loadConfiguration(loggerContext, this.location);
        configuration.start();
        Map appenders = configuration.getAppenders();
        for (Appender appender : appenders.values()) {
            contextConfiguration.addAppender(appender);
        }
        Map loggers = configuration.getLoggers();
        loggers.forEach((arg_0, arg_1) -> ((Configuration)contextConfiguration).addLogger(arg_0, arg_1));
        loggerContext.updateLoggers();
    }

    private Configuration loadConfiguration(LoggerContext loggerContext, String location) {
        try {
            URL url = Log4j2PolarisLogging.getResourceUrl(location);
            ConfigurationSource source = this.getConfigurationSource(url);
            return ConfigurationFactory.getInstance().getConfiguration(loggerContext, source);
        }
        catch (Exception e) {
            throw new IllegalStateException("could not initialize log4j2 logging from " + location, e);
        }
    }

    private ConfigurationSource getConfigurationSource(URL url) throws IOException {
        InputStream stream = url.openStream();
        if (FILE_PROTOCOL.equals(url.getProtocol())) {
            return new ConfigurationSource(stream, Log4j2PolarisLogging.getResourceAsFile(url));
        }
        return new ConfigurationSource(stream, url);
    }
}

