/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.logging.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LogbackException;
import com.tencent.polaris.logging.AbstractPolarisLogging;
import com.tencent.polaris.logging.logback.PolarisJoranConfigurator;
import java.net.URL;
import org.slf4j.LoggerFactory;

public class LogbackPolarisLogging
extends AbstractPolarisLogging {
    private static final String LOGBACK_LOCATION = "classpath:polaris-logback.xml";

    @Override
    public void loadConfiguration() {
        String location = this.getLocation(LOGBACK_LOCATION);
        if (null == location || location.trim().length() == 0) {
            return;
        }
        try {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            URL url = LogbackPolarisLogging.getResourceUrl(location);
            String urlString = url.toString();
            if (!urlString.endsWith("xml")) {
                throw new LogbackException("Unexpected filename extension of file [" + url + "]. Should be either .groovy or .xml");
            }
            PolarisJoranConfigurator configurator = new PolarisJoranConfigurator();
            configurator.setContext((Context)loggerContext);
            configurator.doPolarisConfigure(url);
        }
        catch (Exception e) {
            throw new IllegalStateException("could not initialize logback logging from " + location, e);
        }
    }
}

