/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.client.pojo;

import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.Services;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.client.pb.ResponseProto;
import com.tencent.polaris.client.pb.ServiceProto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ServicesByProto
implements Services,
RegistryCacheValue {
    public static final ServicesByProto EMPTY_SERVICES = new ServicesByProto();
    private final List<ServiceInfo> services;
    private final boolean initialized;
    private final boolean loadedFromFile;
    private final int hashCode;
    private ServiceKey svcKey;

    public ServicesByProto() {
        this.services = Collections.emptyList();
        this.initialized = false;
        this.loadedFromFile = false;
        this.hashCode = 0;
    }

    public ServicesByProto(List<ServiceInfo> services) {
        this.services = services;
        this.initialized = true;
        this.loadedFromFile = false;
        this.hashCode = 0;
    }

    public ServicesByProto(ResponseProto.DiscoverResponse response, boolean loadFromFile) {
        List tmpServices = response.getServicesList();
        this.services = new ArrayList<ServiceInfo>();
        this.svcKey = new ServiceKey("", "");
        if (CollectionUtils.isNotEmpty(tmpServices)) {
            ServiceProto.Service svc = (ServiceProto.Service)tmpServices.get(0);
            this.svcKey = new ServiceKey(svc.getNamespace().getValue(), svc.getName().getValue());
            tmpServices.forEach(service -> this.services.add(ServiceInfo.builder().namespace(service.getNamespace().getValue()).service(service.getName().getValue()).metadata(service.getMetadataMap()).revision(service.getRevision().getValue()).build()));
        }
        this.hashCode = Objects.hash(response.getServicesList());
        this.initialized = true;
        this.loadedFromFile = loadFromFile;
    }

    @Override
    public boolean isLoadedFromFile() {
        return this.loadedFromFile;
    }

    @Override
    public ServiceEventKey.EventType getEventType() {
        return ServiceEventKey.EventType.SERVICE;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public String getRevision() {
        return "";
    }

    public ServiceKey getSvcKey() {
        return this.svcKey;
    }

    @Override
    public ServiceKey getServiceKey() {
        return this.svcKey;
    }

    @Override
    public List<ServiceInfo> getServices() {
        return this.services;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "ServicesByProto{svcKey=" + this.svcKey + ", services=" + this.services + ", initialized=" + this.initialized + ", loadedFromFile=" + this.loadedFromFile + ", hashCode=" + this.hashCode + '}';
    }
}

