/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.pojo;

import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class HalfOpenStatus
extends CircuitBreakerStatus {
    private final AtomicInteger allocated = new AtomicInteger(0);
    private final int maxRequest;
    private final AtomicBoolean scheduled = new AtomicBoolean(false);

    public HalfOpenStatus(String circuitBreaker, long startTimeMs, int maxRequest) {
        super(circuitBreaker, CircuitBreakerStatus.Status.HALF_OPEN, startTimeMs);
        this.maxRequest = maxRequest;
    }

    public int getMaxRequest() {
        return this.maxRequest;
    }

    public boolean allocate() {
        int result = this.allocated.incrementAndGet();
        return result <= this.maxRequest;
    }

    public boolean schedule() {
        return this.scheduled.compareAndSet(false, true);
    }
}

