/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.utils;

import com.tencent.polaris.api.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.StringJoiner;

public class StringUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static String defaultString(String value) {
        if (null == value) {
            return "";
        }
        return value;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static boolean equals(String str1, String str2) {
        return Objects.equals(str1, str2);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isAllEmpty(String ... str) {
        for (String s : str) {
            if (StringUtils.isEmpty(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyEmpty(String ... str) {
        for (String s : str) {
            if (!StringUtils.isEmpty(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        if (!StringUtils.isEmpty(text) && !StringUtils.isEmpty(searchString) && replacement != null && max != 0) {
            int start = 0;
            int end = text.indexOf(searchString, start);
            if (end == -1) {
                return text;
            }
            int replLength = searchString.length();
            int increase = replacement.length() - replLength;
            int n = increase = increase < 0 ? 0 : increase;
            StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
            while (end != -1) {
                buf.append(text.substring(start, end)).append(replacement);
                start = end + replLength;
                if (--max == 0) break;
                end = text.indexOf(searchString, start);
            }
            buf.append(text.substring(start));
            return buf.toString();
        }
        return text;
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        if (index + substring.length() > str.length()) {
            return false;
        }
        for (int i = 0; i < substring.length(); ++i) {
            if (str.charAt(index + i) == substring.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        return StringUtils.delimitedListToStringArray(str, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if (delimiter.isEmpty()) {
            for (int pos = 0; pos < str.length(); ++pos) {
                result.add(StringUtils.deleteAny(str.substring(pos, pos + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(StringUtils.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(StringUtils.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] toStringArray(Collection<String> collection) {
        return !CollectionUtils.isEmpty(collection) ? collection.toArray(EMPTY_STRING_ARRAY) : EMPTY_STRING_ARRAY;
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (StringUtils.isNotBlank(inString) && StringUtils.isNotBlank(charsToDelete)) {
            int lastCharIndex = 0;
            char[] result = new char[inString.length()];
            for (int i = 0; i < inString.length(); ++i) {
                char c = inString.charAt(i);
                if (charsToDelete.indexOf(c) != -1) continue;
                result[lastCharIndex++] = c;
            }
            if (lastCharIndex == inString.length()) {
                return inString;
            }
            return new String(result, 0, lastCharIndex);
        }
        return inString;
    }

    public static String arrayToDelimitedString(Object[] arr, String delim) {
        if (CollectionUtils.isEmpty(arr)) {
            return "";
        }
        if (arr.length == 1) {
            return StringUtils.nullSafeToString(arr[0]);
        }
        StringJoiner sj = new StringJoiner(delim);
        Object[] var3 = arr;
        int var4 = arr.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            Object elem = var3[var5];
            sj.add(String.valueOf(elem));
        }
        return sj.toString();
    }

    public static String nullSafeToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Object[]) {
            return StringUtils.nullSafeToString((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return StringUtils.nullSafeToString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return StringUtils.nullSafeToString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return StringUtils.nullSafeToString((char[])obj);
        }
        if (obj instanceof double[]) {
            return StringUtils.nullSafeToString((double[])obj);
        }
        if (obj instanceof float[]) {
            return StringUtils.nullSafeToString((float[])obj);
        }
        if (obj instanceof int[]) {
            return StringUtils.nullSafeToString((int[])obj);
        }
        if (obj instanceof long[]) {
            return StringUtils.nullSafeToString((long[])obj);
        }
        if (obj instanceof short[]) {
            return StringUtils.nullSafeToString((short[])obj);
        }
        String str = obj.toString();
        return str != null ? str : "";
    }
}

