/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.pojo;

import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class HalfOpenStatus
extends CircuitBreakerStatus {
    private final AtomicInteger allocated = new AtomicInteger(0);
    private final int maxRequest;
    private final AtomicBoolean scheduled = new AtomicBoolean(false);
    private final List<Boolean> calledResult;
    private boolean triggered = false;
    private final Object lock = new Object();

    public HalfOpenStatus(String circuitBreaker, long startTimeMs, int maxRequest) {
        super(circuitBreaker, CircuitBreakerStatus.Status.HALF_OPEN, startTimeMs);
        this.maxRequest = maxRequest;
        this.calledResult = new ArrayList<Boolean>(maxRequest * 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean report(boolean success) {
        Object object = this.lock;
        synchronized (object) {
            boolean needTrigger;
            this.calledResult.add(success);
            boolean bl = needTrigger = !success || this.calledResult.size() >= this.maxRequest;
            if (needTrigger && !this.triggered) {
                this.triggered = true;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CircuitBreakerStatus.Status calNextStatus() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.triggered) {
                return CircuitBreakerStatus.Status.HALF_OPEN;
            }
            for (Boolean result : this.calledResult) {
                if (result.booleanValue()) continue;
                return CircuitBreakerStatus.Status.OPEN;
            }
            return CircuitBreakerStatus.Status.CLOSE;
        }
    }

    public boolean schedule() {
        return this.scheduled.compareAndSet(false, true);
    }
}

