/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.utils;

import com.tencent.polaris.api.utils.MapUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class RuleUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RuleUtils.class);
    public static final String MATCH_ALL = "*";
    private static final Function<String, Pattern> DEFAULT_REGEX_PATTERN = new Function<String, Pattern>(){

        @Override
        public Pattern apply(String s) {
            return Pattern.compile(s);
        }
    };

    public static boolean isMatchAllValue(ModelProto.MatchString ruleMetaValue) {
        if (ruleMetaValue.getValueType() != ModelProto.MatchString.ValueType.TEXT) {
            return false;
        }
        return RuleUtils.isMatchAllValue(ruleMetaValue.getValue().getValue());
    }

    public static boolean isMatchAllValue(String value) {
        return StringUtils.isEmpty(value) || StringUtils.equals(value, MATCH_ALL);
    }

    public static boolean matchStringValue(ModelProto.MatchString matchString, String actualValue, Function<String, Pattern> regexToPattern) {
        ModelProto.MatchString.MatchStringType matchType = matchString.getType();
        String matchValue = matchString.getValue().getValue();
        return RuleUtils.matchStringValue(matchType, actualValue, matchValue, regexToPattern);
    }

    public static boolean matchStringValue(ModelProto.MatchString.MatchStringType matchType, String actualValue, String matchValue) {
        return RuleUtils.matchStringValue(matchType, actualValue, matchValue, DEFAULT_REGEX_PATTERN);
    }

    private static boolean matchStringValue(ModelProto.MatchString.MatchStringType matchType, String actualValue, String matchValue, Function<String, Pattern> regexToPattern) {
        actualValue = StringUtils.defaultString(actualValue);
        if (RuleUtils.isMatchAllValue(matchValue = StringUtils.defaultString(matchValue))) {
            return true;
        }
        switch (matchType) {
            case EXACT: {
                return StringUtils.equals(actualValue, matchValue);
            }
            case REGEX: {
                Pattern pattern = regexToPattern.apply(matchValue);
                return pattern.matcher(actualValue).find();
            }
            case NOT_EQUALS: {
                return !StringUtils.equals(actualValue, matchValue);
            }
            case IN: {
                String[] tokens;
                for (String token : tokens = matchValue.split(",")) {
                    if (!StringUtils.equals(token, actualValue)) continue;
                    return true;
                }
                return false;
            }
            case NOT_IN: {
                String[] tokens;
                for (String token : tokens = matchValue.split(",")) {
                    if (!StringUtils.equals(token, actualValue)) continue;
                    return false;
                }
                return true;
            }
            case RANGE: {
                String[] tokens = matchValue.split("~");
                if (tokens.length != 2) {
                    return false;
                }
                try {
                    long left = Long.parseLong(tokens[0]);
                    long right = Long.parseLong(tokens[1]);
                    long matchV = Long.parseLong(actualValue);
                    return matchV >= left && matchV <= right;
                }
                catch (NumberFormatException ignore) {
                    LOG.error("[RuleUtils] actualValue {} is not a number in RANGE match type, return false", (Object)actualValue);
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean matchMetadata(Map<String, ModelProto.MatchString> ruleMeta, Map<String, String> destMeta) {
        return RuleUtils.matchMetadata(ruleMeta, destMeta, false, Collections.emptyMap(), Collections.emptyMap());
    }

    public static boolean matchMetadata(Map<String, ModelProto.MatchString> ruleMeta, Map<String, String> destMeta, boolean isMatchSource, Map<String, String> multiEnvRouterParamMap, Map<String, String> variables) {
        if (MapUtils.isEmpty(ruleMeta)) {
            return true;
        }
        if (ruleMeta.containsKey(MATCH_ALL)) {
            return true;
        }
        if (MapUtils.isEmpty(destMeta)) {
            return false;
        }
        boolean allMetaMatched = true;
        int matchNum = 0;
        for (Map.Entry<String, ModelProto.MatchString> entry : ruleMeta.entrySet()) {
            String ruleMetaKey = entry.getKey();
            ModelProto.MatchString ruleMetaValue = entry.getValue();
            if (RuleUtils.isMatchAllValue(ruleMetaValue)) {
                ++matchNum;
                continue;
            }
            if (destMeta.containsKey(ruleMetaKey)) {
                ++matchNum;
                if (!ruleMetaValue.hasValue() && ruleMetaValue.getValueType() != ModelProto.MatchString.ValueType.PARAMETER) continue;
                String destMetaValue = destMeta.get(ruleMetaKey);
                allMetaMatched = RuleUtils.isAllMetaMatched(isMatchSource, ruleMetaKey, ruleMetaValue, destMetaValue, multiEnvRouterParamMap, variables);
            }
            if (allMetaMatched) continue;
            break;
        }
        if (matchNum == 0) {
            allMetaMatched = false;
        }
        if (matchNum != ruleMeta.entrySet().size()) {
            allMetaMatched = false;
        }
        return allMetaMatched;
    }

    private static boolean isAllMetaMatched(boolean isMatchSource, String ruleMetaKey, ModelProto.MatchString ruleMetaValue, String destMetaValue, Map<String, String> multiEnvRouterParamMap, Map<String, String> variables) {
        if (MATCH_ALL.equals(destMetaValue)) {
            return true;
        }
        return RuleUtils.matchValueByValueType(isMatchSource, ruleMetaKey, ruleMetaValue, destMetaValue, multiEnvRouterParamMap, variables);
    }

    private static boolean matchValueByValueType(boolean isMatchSource, String ruleMetaKey, ModelProto.MatchString ruleMetaValue, String destMetaValue, Map<String, String> multiEnvRouterParamMap, Map<String, String> variables) {
        boolean allMetaMatched = true;
        switch (ruleMetaValue.getValueType()) {
            case PARAMETER: {
                if (isMatchSource) {
                    multiEnvRouterParamMap.put(ruleMetaKey, destMetaValue);
                    break;
                }
                if (!multiEnvRouterParamMap.containsKey(ruleMetaValue.getValue().getValue())) {
                    allMetaMatched = false;
                    break;
                }
                String ruleValue = multiEnvRouterParamMap.get(ruleMetaValue.getValue().getValue());
                allMetaMatched = RuleUtils.matchStringValue(ruleMetaValue.getType(), ruleValue, destMetaValue);
                break;
            }
            case VARIABLE: {
                if (variables.containsKey(ruleMetaKey)) {
                    String ruleValue = variables.get(ruleMetaKey);
                    allMetaMatched = RuleUtils.matchStringValue(ruleMetaValue.getType(), destMetaValue, ruleValue);
                    break;
                }
                String key = ruleMetaValue.getValue().getValue();
                if (!System.getenv().containsKey(key)) {
                    allMetaMatched = false;
                } else {
                    String value = System.getenv(key);
                    allMetaMatched = RuleUtils.matchStringValue(ruleMetaValue.getType(), destMetaValue, value);
                }
                if (System.getenv().containsKey(key) && System.getenv(key).equals(destMetaValue)) break;
                allMetaMatched = false;
                break;
            }
            default: {
                allMetaMatched = RuleUtils.matchStringValue(ruleMetaValue.getType(), destMetaValue, ruleMetaValue.getValue().getValue());
            }
        }
        return allMetaMatched;
    }
}

