/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolUtils.class);

    public static void waitAndStopThreadPools(ExecutorService[] services) {
        for (ExecutorService service : services) {
            if (null == service) continue;
            service.shutdown();
        }
        for (ExecutorService service : services) {
            if (null == service) continue;
            try {
                service.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("interrupted while waiting thread pool terminated", (Throwable)e);
            }
        }
    }
}

