/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.client.util;

import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.api.utils.StringUtils;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);

    public static long sleepUninterrupted(long millis) {
        long currentTime = System.currentTimeMillis();
        long deadline = currentTime + millis;
        while (currentTime < deadline) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                LOG.debug(String.format("interrupted while sleeping %d", millis), (Throwable)e);
            }
            currentTime = System.currentTimeMillis();
        }
        return currentTime;
    }

    public static String translatePath(String path) {
        if (path.startsWith("$HOME")) {
            String userHome = System.getProperty("user.home");
            return StringUtils.replace(path, "$HOME", userHome);
        }
        return path;
    }

    public static boolean regMatch(String regex, String input) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        return m.matches();
    }

    public static boolean isHealthyInstance(Instance instance, Map<StatusDimension.Level, StatusDimension> dimensions) {
        if (!instance.isHealthy()) {
            return false;
        }
        for (StatusDimension statusDimension : dimensions.values()) {
            CircuitBreakerStatus circuitBreakerStatus = instance.getCircuitBreakerStatus(statusDimension);
            if (null == circuitBreakerStatus || circuitBreakerStatus.getStatus() != CircuitBreakerStatus.Status.OPEN) continue;
            return false;
        }
        return true;
    }
}

