/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.client.util;

import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceChangeEvent;
import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.pojo.ServiceInstancesByProto;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);

    public static long sleepUninterrupted(long millis) {
        long currentTime = System.currentTimeMillis();
        long deadline = currentTime + millis;
        while (currentTime < deadline) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                LOG.debug(String.format("interrupted while sleeping %d", millis), (Throwable)e);
            }
            currentTime = System.currentTimeMillis();
        }
        return currentTime;
    }

    public static String translatePath(String path) {
        if (path.startsWith("$HOME")) {
            String userHome = System.getProperty("user.home");
            return StringUtils.replace(path, "$HOME", userHome);
        }
        return path;
    }

    public static boolean regMatch(String regex, String input) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        return m.matches();
    }

    public static boolean isHealthyInstance(Instance instance, Map<StatusDimension.Level, StatusDimension> dimensions) {
        if (!instance.isHealthy()) {
            return false;
        }
        for (StatusDimension statusDimension : dimensions.values()) {
            CircuitBreakerStatus circuitBreakerStatus = instance.getCircuitBreakerStatus(statusDimension);
            if (null == circuitBreakerStatus || circuitBreakerStatus.getStatus() != CircuitBreakerStatus.Status.OPEN) continue;
            return false;
        }
        return true;
    }

    public static List<Instance> checkAddInstances(ServiceInstancesByProto oldVal, ServiceInstancesByProto newVal) {
        HashSet<Instance> oldIns = new HashSet<Instance>(oldVal.getInstances());
        HashSet<Instance> newIns = new HashSet<Instance>(newVal.getInstances());
        LinkedList<Instance> ret = new LinkedList<Instance>();
        for (Instance instance : newIns) {
            if (oldIns.contains(instance)) continue;
            ret.add(instance);
        }
        return ret;
    }

    public static List<ServiceChangeEvent.OneInstanceUpdate> checkUpdateInstances(ServiceInstancesByProto oldVal, ServiceInstancesByProto newVal) {
        Map<String, Instance> oldIns = oldVal.getInstances().stream().collect(Collectors.toMap(Instance::getId, instance -> instance));
        Map<String, Instance> newIns = newVal.getInstances().stream().collect(Collectors.toMap(Instance::getId, instance -> instance));
        LinkedList<ServiceChangeEvent.OneInstanceUpdate> ret = new LinkedList<ServiceChangeEvent.OneInstanceUpdate>();
        oldIns.forEach((id, instance) -> {
            Instance ins = (Instance)newIns.get(id);
            if (ins == null) {
                return;
            }
            if (!Objects.equals(ins.getRevision(), instance.getRevision())) {
                ret.add(new ServiceChangeEvent.OneInstanceUpdate((Instance)instance, ins));
            }
        });
        return ret;
    }

    public static List<Instance> checkDeleteInstances(ServiceInstancesByProto oldVal, ServiceInstancesByProto newVal) {
        HashSet<Instance> oldIns = new HashSet<Instance>(oldVal.getInstances());
        HashSet<Instance> newIns = new HashSet<Instance>(newVal.getInstances());
        LinkedList<Instance> ret = new LinkedList<Instance>();
        for (Instance instance : oldIns) {
            if (newIns.contains(instance)) continue;
            ret.add(instance);
        }
        return ret;
    }
}

