/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.exception;

import com.tencent.polaris.api.exception.ErrorCode;

public class PolarisException
extends RuntimeException {
    private final ErrorCode code;

    public PolarisException(ErrorCode code) {
        this.code = code;
    }

    public PolarisException(ErrorCode code, String message) {
        super(message);
        this.code = code;
    }

    public PolarisException(ErrorCode code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder(String.format("ERR-%d(%s), ", this.code.getCode(), this.code.name()));
        builder.append(super.getMessage());
        Throwable cause = this.getCause();
        if (null != cause) {
            builder.append(", cause: ").append(cause.getMessage());
        }
        return builder.toString();
    }

    public ErrorCode getCode() {
        return this.code;
    }
}

