/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.plugin.common;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueContext {
    private static final Logger LOG = LoggerFactory.getLogger(ValueContext.class);
    private static final String KEY_HOST = "key_host";
    private static final String KEY_CLIENT_ID = "key_clientId";
    private final Object lock = new Object();
    private volatile boolean locationReady;
    private final Map<Object, Object> coreMap = new ConcurrentHashMap<Object, Object>();

    public <T> void setValue(String key, T value) {
        this.coreMap.put(key, value);
    }

    public <T> T getValue(String key) {
        return (T)this.coreMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLocationReady(long timeoutMs) throws InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("waitForLocationReady: timeoutMs:{}, is ready:{},object:{}", new Object[]{timeoutMs, this.locationReady, this});
        }
        if (this.locationReady) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait(timeoutMs);
        }
    }

    public String getHost() {
        return (String)this.getValue(KEY_HOST);
    }

    public void setHost(String host) {
        this.setValue(KEY_HOST, host);
    }

    public String getClientId() {
        return (String)this.getValue(KEY_CLIENT_ID);
    }

    public void setClientId(String clientId) {
        this.setValue(KEY_CLIENT_ID, clientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAllForLocationReady() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("notifyAllForLocationReady:object:{}", (Object)this);
        }
        this.locationReady = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }
}

