/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.plugin.compose;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.config.consumer.OutlierDetectionConfig;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.Plugin;
import com.tencent.polaris.api.plugin.Supplier;
import com.tencent.polaris.api.plugin.cache.FlowCache;
import com.tencent.polaris.api.plugin.circuitbreaker.CircuitBreaker;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.common.ValueContext;
import com.tencent.polaris.api.plugin.compose.DefaultRouterChainGroup;
import com.tencent.polaris.api.plugin.compose.RouterChainGroup;
import com.tencent.polaris.api.plugin.detect.OutlierDetector;
import com.tencent.polaris.api.plugin.loadbalance.LoadBalancer;
import com.tencent.polaris.api.plugin.registry.LocalRegistry;
import com.tencent.polaris.api.plugin.route.ServiceRouter;
import com.tencent.polaris.api.plugin.server.ServerConnector;
import com.tencent.polaris.api.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Extensions {
    private static final Logger LOG = LoggerFactory.getLogger(Extensions.class);
    private LocalRegistry localRegistry;
    private ServerConnector serverConnector;
    private LoadBalancer loadBalancer;
    private final List<CircuitBreaker> circuitBreakers = new ArrayList<CircuitBreaker>();
    private final List<OutlierDetector> outlierDetectors = new ArrayList<OutlierDetector>();
    private Configuration configuration;
    private Supplier plugins;
    private RouterChainGroup sysRouterChainGroup;
    private RouterChainGroup configRouterChainGroup;
    private FlowCache flowCache;
    private ValueContext valueContext;

    public void init(Configuration config, Supplier plugins, ValueContext valueContext) throws PolarisException {
        this.configuration = config;
        this.plugins = plugins;
        this.valueContext = valueContext;
        String localCacheType = config.getConsumer().getLocalCache().getType();
        this.localRegistry = (LocalRegistry)plugins.getPlugin(PluginTypes.LOCAL_REGISTRY.getBaseType(), localCacheType);
        String flowCacheName = config.getGlobal().getSystem().getFlowCache().getName();
        this.flowCache = (FlowCache)plugins.getPlugin(PluginTypes.FLOW_CACHE.getBaseType(), flowCacheName);
        String loadBalanceType = config.getConsumer().getLoadbalancer().getType();
        this.loadBalancer = (LoadBalancer)plugins.getPlugin(PluginTypes.LOAD_BALANCER.getBaseType(), loadBalanceType);
        List<ServiceRouter> beforeRouters = Extensions.loadServiceRouters(config.getConsumer().getServiceRouter().getBeforeChain(), plugins, true);
        List<ServiceRouter> coreRouters = Extensions.loadServiceRouters(config.getConsumer().getServiceRouter().getChain(), plugins, false);
        List<ServiceRouter> afterRouters = Extensions.loadServiceRouters(config.getConsumer().getServiceRouter().getAfterChain(), plugins, true);
        this.configRouterChainGroup = new DefaultRouterChainGroup(beforeRouters, coreRouters, afterRouters);
        ArrayList<String> sysBefore = new ArrayList<String>();
        sysBefore.add("isolatedRouter");
        ArrayList<String> sysAfter = new ArrayList<String>();
        sysAfter.add("recoverRouter");
        List<ServiceRouter> sysBeforeRouters = Extensions.loadServiceRouters(sysBefore, plugins, true);
        List<ServiceRouter> sysAfterRouters = Extensions.loadServiceRouters(sysAfter, plugins, true);
        this.sysRouterChainGroup = new DefaultRouterChainGroup(sysBeforeRouters, Collections.emptyList(), sysAfterRouters);
        boolean enable = config.getConsumer().getCircuitBreaker().isEnable();
        List cbChain = config.getConsumer().getCircuitBreaker().getChain();
        if (enable && CollectionUtils.isNotEmpty((Collection)cbChain)) {
            for (String cbName : cbChain) {
                Plugin pluginValue = plugins.getOptionalPlugin(PluginTypes.CIRCUIT_BREAKER.getBaseType(), cbName);
                if (null == pluginValue) {
                    LOG.warn("circuitBreaker plugin {} not found", (Object)cbName);
                    continue;
                }
                this.circuitBreakers.add((CircuitBreaker)pluginValue);
            }
        }
        this.loadOutlierDetector(config, plugins);
        String protocol = config.getGlobal().getServerConnector().getProtocol();
        this.serverConnector = (ServerConnector)plugins.getPlugin(PluginTypes.SERVER_CONNECTOR.getBaseType(), protocol);
    }

    public ValueContext getValueContext() {
        return this.valueContext;
    }

    public static List<ServiceRouter> loadServiceRouters(List<String> routerChain, Supplier plugins, boolean force) {
        ArrayList<ServiceRouter> routers = new ArrayList<ServiceRouter>();
        if (CollectionUtils.isNotEmpty(routerChain)) {
            for (String routerName : routerChain) {
                Plugin routerPlugin = force ? plugins.getPlugin(PluginTypes.SERVICE_ROUTER.getBaseType(), routerName) : plugins.getOptionalPlugin(PluginTypes.SERVICE_ROUTER.getBaseType(), routerName);
                if (null == routerPlugin) {
                    LOG.warn("router {} not found", (Object)routerName);
                    continue;
                }
                routers.add((ServiceRouter)routerPlugin);
            }
        }
        return Collections.unmodifiableList(routers);
    }

    private void loadOutlierDetector(Configuration config, Supplier plugins) throws PolarisException {
        boolean enable = config.getConsumer().getOutlierDetection().getWhen() != OutlierDetectionConfig.When.never;
        List detectionChain = config.getConsumer().getOutlierDetection().getChain();
        if (enable && CollectionUtils.isNotEmpty((Collection)detectionChain)) {
            for (String detectorName : detectionChain) {
                Plugin pluginValue = plugins.getOptionalPlugin(PluginTypes.OUTLIER_DETECTOR.getBaseType(), detectorName);
                if (null == pluginValue) {
                    LOG.warn("outlierDetector plugin {} not found", (Object)detectorName);
                    continue;
                }
                this.outlierDetectors.add((OutlierDetector)pluginValue);
            }
        }
    }

    public Supplier getPlugins() {
        return this.plugins;
    }

    public LocalRegistry getLocalRegistry() {
        return this.localRegistry;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public List<CircuitBreaker> getCircuitBreakers() {
        return this.circuitBreakers;
    }

    public List<OutlierDetector> getOutlierDetectors() {
        return this.outlierDetectors;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ServerConnector getServerConnector() {
        return this.serverConnector;
    }

    public RouterChainGroup getSysRouterChainGroup() {
        return this.sysRouterChainGroup;
    }

    public RouterChainGroup getConfigRouterChainGroup() {
        return this.configRouterChainGroup;
    }

    public FlowCache getFlowCache() {
        return this.flowCache;
    }
}

