/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.plugin.route;

import com.tencent.polaris.api.plugin.route.RouteResult;
import com.tencent.polaris.api.pojo.Service;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import com.tencent.polaris.api.pojo.ServiceRule;
import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.api.rpc.MetadataFailoverType;
import com.tencent.polaris.api.utils.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RouteInfo {
    private final ServiceMetadata sourceService;
    private final ServiceMetadata destService;
    private ServiceRule sourceRouteRule;
    private ServiceRule destRouteRule;
    private String canary;
    private final Map<StatusDimension.Level, StatusDimension> statusDimensions;
    private final Map<String, Boolean> chainEnable = new HashMap<String, Boolean>();
    private boolean includeUnhealthyInstances;
    private boolean includeCircuitBreakInstances;
    private MetadataFailoverType metadataFailoverType;
    private RouteResult.NextRouterInfo nextRouterInfo;

    public RouteInfo(ServiceMetadata sourceService, ServiceRule sourceRouteRule, ServiceMetadata destService, ServiceRule destRouteRule, String method) {
        this.sourceService = sourceService;
        this.sourceRouteRule = sourceRouteRule;
        this.destService = destService;
        this.destRouteRule = destRouteRule;
        HashMap<StatusDimension.Level, StatusDimension> dimensionMap = new HashMap<StatusDimension.Level, StatusDimension>();
        dimensionMap.put(StatusDimension.Level.SERVICE, StatusDimension.EMPTY_DIMENSION);
        if (StringUtils.isNotBlank((String)method)) {
            dimensionMap.put(StatusDimension.Level.ALL_CALLER, new StatusDimension(method, null));
        }
        if (null != sourceService) {
            dimensionMap.put(StatusDimension.Level.ALL_METHOD, new StatusDimension("", (Service)sourceService));
        }
        if (StringUtils.isNotBlank((String)method) && null != sourceService) {
            dimensionMap.put(StatusDimension.Level.CALLER_METHOD, new StatusDimension(method, (Service)sourceService));
        }
        this.statusDimensions = Collections.unmodifiableMap(dimensionMap);
    }

    public RouteInfo(ServiceMetadata sourceService, ServiceMetadata destService, String method) {
        this(sourceService, null, destService, null, method);
    }

    public MetadataFailoverType getMetadataFailoverType() {
        return this.metadataFailoverType;
    }

    public void setMetadataFailoverType(MetadataFailoverType metadataFailoverType) {
        this.metadataFailoverType = metadataFailoverType;
    }

    public Map<StatusDimension.Level, StatusDimension> getStatusDimensions() {
        return this.statusDimensions;
    }

    public void setSourceRouteRule(ServiceRule sourceRouteRule) {
        this.sourceRouteRule = sourceRouteRule;
    }

    public void setDestRouteRule(ServiceRule destRouteRule) {
        this.destRouteRule = destRouteRule;
    }

    public RouteResult.NextRouterInfo getNextRouterInfo() {
        return this.nextRouterInfo;
    }

    public void setNextRouterInfo(RouteResult.NextRouterInfo nextRouterInfo) {
        this.nextRouterInfo = nextRouterInfo;
    }

    public String getCanary() {
        return this.canary;
    }

    public void setCanary(String canary) {
        this.canary = canary;
    }

    public Boolean routerIsEnabled(String routerType) {
        return this.chainEnable.get(routerType);
    }

    public void enableRouter(String routerType) {
        this.chainEnable.put(routerType, true);
    }

    public void disableRouter(String routerType) {
        this.chainEnable.put(routerType, false);
    }

    public ServiceMetadata getSourceService() {
        return this.sourceService;
    }

    public ServiceRule getSourceRouteRule() {
        return this.sourceRouteRule;
    }

    public ServiceMetadata getDestService() {
        return this.destService;
    }

    public ServiceRule getDestRouteRule() {
        return this.destRouteRule;
    }

    public boolean isIncludeUnhealthyInstances() {
        return this.includeUnhealthyInstances;
    }

    public void setIncludeUnhealthyInstances(boolean includeUnhealthyInstances) {
        this.includeUnhealthyInstances = includeUnhealthyInstances;
    }

    public boolean isIncludeCircuitBreakInstances() {
        return this.includeCircuitBreakInstances;
    }

    public void setIncludeCircuitBreakInstances(boolean includeCircuitBreakInstances) {
        this.includeCircuitBreakInstances = includeCircuitBreakInstances;
    }
}

