/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.plugin.circuitbreaker.entity;

import com.tencent.polaris.api.plugin.circuitbreaker.entity.AbstractResource;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.client.util.CommonValidator;
import com.tencent.polaris.specification.api.v1.fault.tolerance.CircuitBreakerProto;
import java.util.Objects;

public class InstanceResource
extends AbstractResource {
    private final String host;
    private final int port;

    public InstanceResource(ServiceKey service, String host, int port) {
        this(service, host, port, null);
    }

    public InstanceResource(ServiceKey service, String host, int port, ServiceKey callerService) {
        super(service, callerService);
        CommonValidator.validateService((ServiceKey)service);
        CommonValidator.validateNamespaceService((String)service.getNamespace(), (String)service.getService());
        CommonValidator.validateText((String)host, (String)"host");
        this.host = host;
        this.port = port;
    }

    @Override
    public CircuitBreakerProto.Level getLevel() {
        return CircuitBreakerProto.Level.INSTANCE;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public ServiceKey getService() {
        return this.service;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceResource)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InstanceResource that = (InstanceResource)o;
        return this.port == that.port && Objects.equals(this.host, that.host);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.host, this.port);
    }

    @Override
    public String toString() {
        return "InstanceResource{host='" + this.host + '\'' + ", port=" + this.port + "} " + super.toString();
    }
}

