/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.plugin.circuitbreaker.entity;

import com.tencent.polaris.api.plugin.circuitbreaker.entity.AbstractResource;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.client.util.CommonValidator;
import com.tencent.polaris.specification.api.v1.fault.tolerance.CircuitBreakerProto;
import java.util.Objects;

public class MethodResource
extends AbstractResource {
    private final String method;

    public MethodResource(ServiceKey service, String methodName) {
        this(service, methodName, null);
    }

    public MethodResource(ServiceKey service, String methodName, ServiceKey callerService) {
        super(service, callerService);
        CommonValidator.validateService((ServiceKey)service);
        CommonValidator.validateNamespaceService((String)service.getNamespace(), (String)service.getService());
        CommonValidator.validateText((String)methodName, (String)"method");
        this.method = methodName;
    }

    @Override
    public CircuitBreakerProto.Level getLevel() {
        return CircuitBreakerProto.Level.METHOD;
    }

    @Override
    public ServiceKey getService() {
        return this.service;
    }

    public String getMethod() {
        return this.method;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodResource)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodResource that = (MethodResource)o;
        return Objects.equals(this.method, that.method);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.method);
    }

    @Override
    public String toString() {
        return "MethodResource{method='" + this.method + '\'' + "} " + super.toString();
    }
}

