/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.plugin.circuitbreaker.entity;

import com.tencent.polaris.api.plugin.circuitbreaker.entity.Resource;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.client.util.CommonValidator;
import java.util.Objects;

public abstract class AbstractResource
implements Resource {
    protected final ServiceKey service;
    protected final ServiceKey callerService;

    public AbstractResource(ServiceKey service, ServiceKey callerService) {
        CommonValidator.validateService((ServiceKey)service);
        CommonValidator.validateNamespaceService((String)service.getNamespace(), (String)service.getService());
        this.service = service;
        this.callerService = callerService;
    }

    @Override
    public ServiceKey getService() {
        return this.service;
    }

    @Override
    public ServiceKey getCallerService() {
        return this.callerService;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractResource)) {
            return false;
        }
        AbstractResource that = (AbstractResource)o;
        return Objects.equals(this.service, that.service) && Objects.equals(this.callerService, that.callerService);
    }

    public int hashCode() {
        return Objects.hash(this.service, this.callerService);
    }

    public String toString() {
        return "AbstractResource{service=" + this.service + ", callerService=" + this.callerService + '}';
    }
}

