/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.plugin.circuitbreaker.entity;

import com.tencent.polaris.api.plugin.circuitbreaker.entity.AbstractResource;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.client.pojo.Node;
import com.tencent.polaris.client.util.CommonValidator;
import com.tencent.polaris.specification.api.v1.fault.tolerance.CircuitBreakerProto;
import java.util.Objects;

public class InstanceResource
extends AbstractResource {
    private final Node node;
    private final String protocol;

    public InstanceResource(ServiceKey service, String host, int port, ServiceKey callerService) {
        this(service, host, port, callerService, "");
    }

    public InstanceResource(ServiceKey service, String host, int port, ServiceKey callerService, String protocol) {
        super(service, callerService);
        CommonValidator.validateText((String)host, (String)"host");
        this.node = new Node(host, port);
        this.protocol = protocol;
    }

    @Override
    public CircuitBreakerProto.Level getLevel() {
        return CircuitBreakerProto.Level.INSTANCE;
    }

    public String getHost() {
        return this.node.getHost();
    }

    public int getPort() {
        return this.node.getPort();
    }

    public Node getNode() {
        return this.node;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceResource)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InstanceResource that = (InstanceResource)o;
        return Objects.equals(this.node, that.node);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.node);
    }

    @Override
    public String toString() {
        return "InstanceResource{node=" + this.node + ", protocol='" + this.protocol + '\'' + "} " + super.toString();
    }
}

