/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.ratelimit.client.flow;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.client.flow.BaseFlow;
import com.tencent.polaris.ratelimit.client.flow.HostIdentifier;
import com.tencent.polaris.ratelimit.client.flow.InitializeRecord;
import com.tencent.polaris.ratelimit.client.flow.ServiceIdentifier;
import com.tencent.polaris.ratelimit.client.flow.StreamCounterSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncRateLimitConnector {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncRateLimitConnector.class);
    private final Map<HostIdentifier, StreamCounterSet> hostToStream = new HashMap<HostIdentifier, StreamCounterSet>();
    private final Map<String, StreamCounterSet> uniqueKeyToStream = new HashMap<String, StreamCounterSet>();
    private final Configuration configuration;
    private final AtomicLong timeDiff = new AtomicLong();
    private final AtomicLong lastSyncTimeMilli = new AtomicLong();
    private final List<String> coreRouters = new ArrayList<String>();

    public AsyncRateLimitConnector(Configuration configuration) {
        this.configuration = configuration;
        this.coreRouters.add("metadataRouter");
    }

    public StreamCounterSet getStreamCounterSet(Extensions extensions, ServiceKey remoteCluster, String uniqueKey, ServiceIdentifier serviceIdentifier) {
        HostIdentifier hostIdentifier = this.getServiceInstance(extensions, remoteCluster, uniqueKey);
        if (hostIdentifier == null) {
            LOG.error("[getStreamCounterSet] rate limit cluster service not found.");
            return null;
        }
        StreamCounterSet streamCounterSet = this.uniqueKeyToStream.get(uniqueKey);
        if (null != streamCounterSet) {
            if (streamCounterSet.getIdentifier().equals(hostIdentifier)) {
                return streamCounterSet;
            }
            Map<ServiceIdentifier, InitializeRecord> initRecord = streamCounterSet.getInitRecord();
            if (null != initRecord) {
                initRecord.remove(serviceIdentifier);
            }
            if (streamCounterSet.decreaseReference()) {
                this.hostToStream.remove(hostIdentifier);
            }
        }
        if (null == (streamCounterSet = this.hostToStream.get(hostIdentifier))) {
            streamCounterSet = new StreamCounterSet(this, hostIdentifier, this.configuration);
        }
        streamCounterSet.addReference();
        return streamCounterSet;
    }

    private HostIdentifier getServiceInstance(Extensions extensions, ServiceKey remoteCluster, String hashValue) {
        Instance instance = BaseFlow.commonGetOneInstance((Extensions)extensions, (ServiceKey)remoteCluster, this.coreRouters, (String)"ringHash", (String)"grpc", (String)hashValue);
        if (instance == null) {
            LOG.error("can not found any instance by serviceKye:{}", (Object)remoteCluster);
            return null;
        }
        String host = instance.getHost();
        int port = instance.getPort();
        return new HostIdentifier(host, port);
    }

    public AtomicLong getTimeDiff() {
        return this.timeDiff;
    }

    public AtomicLong getLastSyncTimeMilli() {
        return this.lastSyncTimeMilli;
    }
}

