/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.ratelimit.client.api;

import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.Plugin;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.stat.DefaultRateLimitResult;
import com.tencent.polaris.api.plugin.stat.RateLimitGauge;
import com.tencent.polaris.api.plugin.stat.StatInfo;
import com.tencent.polaris.api.plugin.stat.StatReporter;
import com.tencent.polaris.client.api.BaseEngine;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.ratelimit.api.core.LimitAPI;
import com.tencent.polaris.ratelimit.api.rpc.QuotaRequest;
import com.tencent.polaris.ratelimit.api.rpc.QuotaResponse;
import com.tencent.polaris.ratelimit.api.rpc.QuotaResultCode;
import com.tencent.polaris.ratelimit.client.flow.QuotaFlow;
import com.tencent.polaris.ratelimit.client.pojo.CommonQuotaRequest;
import com.tencent.polaris.ratelimit.client.utils.LimitValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;

public class DefaultLimitAPI
extends BaseEngine
implements LimitAPI {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLimitAPI.class);
    private final QuotaFlow quotaFlow = new QuotaFlow();
    private Collection<Plugin> statPlugins;

    public DefaultLimitAPI(SDKContext sdkContext) {
        super(sdkContext);
    }

    protected void subInit() {
        this.quotaFlow.init(this.sdkContext.getExtensions());
        this.sdkContext.registerDestroyHook(new Destroyable(){

            protected void doDestroy() {
                DefaultLimitAPI.this.quotaFlow.destroy();
            }
        });
        this.statPlugins = this.sdkContext.getPlugins().getPlugins(PluginTypes.STAT_REPORTER.getBaseType());
    }

    public QuotaResponse getQuota(QuotaRequest request) throws PolarisException {
        this.checkAvailable("LimitAPI");
        LimitValidator.validateQuotaRequest(request);
        CommonQuotaRequest commonQuotaRequest = new CommonQuotaRequest(request, this.sdkContext.getConfig());
        QuotaResponse response = this.quotaFlow.getQuota(commonQuotaRequest);
        this.reportRateLimit(request, response);
        return response;
    }

    private void reportRateLimit(QuotaRequest req, QuotaResponse rsp) {
        if (null != this.statPlugins) {
            try {
                DefaultRateLimitResult rateLimitGauge = new DefaultRateLimitResult();
                rateLimitGauge.setLabels(DefaultLimitAPI.formatLabelsToStr(req.getLabels()));
                rateLimitGauge.setMethod(req.getMethod());
                rateLimitGauge.setNamespace(req.getNamespace());
                rateLimitGauge.setService(req.getService());
                rateLimitGauge.setResult(rsp.getCode() == QuotaResultCode.QuotaResultOk ? RateLimitGauge.Result.PASSED : RateLimitGauge.Result.LIMITED);
                StatInfo statInfo = new StatInfo();
                statInfo.setRateLimitGauge((RateLimitGauge)rateLimitGauge);
                for (Plugin statPlugin : this.statPlugins) {
                    if (!(statPlugin instanceof StatReporter)) continue;
                    ((StatReporter)statPlugin).reportStat(statInfo);
                }
            }
            catch (Exception ex) {
                LOG.info("rate limit report encountered exception, e: {}", (Object)ex.getMessage());
            }
        }
    }

    private static String formatLabelsToStr(Map<String, String> labels) {
        if (null == labels) {
            return null;
        }
        if (labels.isEmpty()) {
            return "";
        }
        ArrayList<String> tmpList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            String labelEntry = entry.getKey() + ":" + labels.get(entry.getKey());
            tmpList.add(labelEntry);
        }
        Collections.sort(tmpList);
        return String.join((CharSequence)"|", tmpList);
    }
}

