/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.ratelimit.client.codec;

import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import com.tencent.polaris.api.plugin.registry.AbstractCacheHandler;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.RuleUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.pojo.ServiceRuleByProto;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import com.tencent.polaris.specification.api.v1.service.manage.ResponseProto;
import com.tencent.polaris.specification.api.v1.traffic.manage.RateLimitProto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RateLimitingCacheHandler
extends AbstractCacheHandler {
    private static final int RULE_SERVICE_LEVEL = 1;
    private static final int RULE_METHOD_LEVEL = 2;
    private static final int RULE_ARGUMENT_LEVEL = 3;

    public ServiceEventKey.EventType getTargetEventType() {
        return ServiceEventKey.EventType.RATE_LIMITING;
    }

    protected String getRevision(ResponseProto.DiscoverResponse discoverResponse) {
        RateLimitProto.RateLimit rateLimit = discoverResponse.getRateLimit();
        if (null == rateLimit) {
            return "";
        }
        return rateLimit.getRevision().getValue();
    }

    public RegistryCacheValue messageToCacheValue(RegistryCacheValue oldValue, Object newValue, boolean isCacheLoaded) {
        ResponseProto.DiscoverResponse discoverResponse = (ResponseProto.DiscoverResponse)newValue;
        RateLimitProto.RateLimit rateLimit = discoverResponse.getRateLimit();
        String revision = this.getRevision(discoverResponse);
        List<RateLimitProto.Rule> sortedRules = this.unifiedRules(rateLimit.getRulesList());
        sortedRules.sort(RateLimitingCacheHandler::compareRule);
        Collections.reverse(sortedRules);
        RateLimitProto.RateLimit newRateLimit = RateLimitProto.RateLimit.newBuilder().addAllRules(sortedRules).setRevision(StringValue.newBuilder().setValue(revision).build()).build();
        return new ServiceRuleByProto((Message)newRateLimit, revision, isCacheLoaded, this.getTargetEventType());
    }

    private static int getRuleLevel(RateLimitProto.Rule rule) {
        ModelProto.MatchString method = rule.getMethod();
        List argumentsList = rule.getArgumentsList();
        if (CollectionUtils.isNotEmpty((Collection)argumentsList)) {
            return 3 + argumentsList.size();
        }
        if (null != method && !RuleUtils.isMatchAllValue((ModelProto.MatchString)method)) {
            return 2;
        }
        return 1;
    }

    private static int compareRule(RateLimitProto.Rule rule1, RateLimitProto.Rule rule2) {
        RateLimitProto.Rule.Type type2;
        RateLimitProto.Rule.Type type1 = rule1.getType();
        if (type1 != (type2 = rule2.getType())) {
            return type1.getNumber() - type2.getNumber();
        }
        return RateLimitingCacheHandler.getRuleLevel(rule1) - RateLimitingCacheHandler.getRuleLevel(rule2);
    }

    private List<RateLimitProto.Rule> unifiedRules(List<RateLimitProto.Rule> rules) {
        ArrayList<RateLimitProto.Rule> retRules = new ArrayList<RateLimitProto.Rule>();
        if (CollectionUtils.isEmpty(rules)) {
            return rules;
        }
        for (RateLimitProto.Rule rule : rules) {
            if (CollectionUtils.isEmpty((Map)rule.getLabelsMap())) {
                retRules.add(rule);
                continue;
            }
            if (CollectionUtils.isNotEmpty((Collection)rule.getArgumentsList())) {
                retRules.add(rule);
                continue;
            }
            ArrayList<RateLimitProto.MatchArgument> arguments = new ArrayList<RateLimitProto.MatchArgument>();
            for (Map.Entry entry : rule.getLabelsMap().entrySet()) {
                String labelKey = StringUtils.defaultString((String)((String)entry.getKey()));
                if (StringUtils.equals((String)labelKey, (String)"$method")) {
                    arguments.add(RateLimitProto.MatchArgument.newBuilder().setType(RateLimitProto.MatchArgument.Type.METHOD).setValue((ModelProto.MatchString)entry.getValue()).build());
                    continue;
                }
                if (StringUtils.equals((String)labelKey, (String)"$caller_ip")) {
                    arguments.add(RateLimitProto.MatchArgument.newBuilder().setType(RateLimitProto.MatchArgument.Type.CALLER_IP).setValue((ModelProto.MatchString)entry.getValue()).build());
                    continue;
                }
                if (labelKey.startsWith("$header.")) {
                    arguments.add(RateLimitProto.MatchArgument.newBuilder().setType(RateLimitProto.MatchArgument.Type.HEADER).setKey(labelKey.substring("$header.".length())).setValue((ModelProto.MatchString)entry.getValue()).build());
                    continue;
                }
                if (labelKey.startsWith("$query.")) {
                    arguments.add(RateLimitProto.MatchArgument.newBuilder().setType(RateLimitProto.MatchArgument.Type.QUERY).setKey(labelKey.substring("$query.".length())).setValue((ModelProto.MatchString)entry.getValue()).build());
                    continue;
                }
                if (labelKey.startsWith("$caller_service.")) {
                    arguments.add(RateLimitProto.MatchArgument.newBuilder().setType(RateLimitProto.MatchArgument.Type.CALLER_SERVICE).setKey(labelKey.substring("$caller_service.".length())).setValue((ModelProto.MatchString)entry.getValue()).build());
                    continue;
                }
                arguments.add(RateLimitProto.MatchArgument.newBuilder().setType(RateLimitProto.MatchArgument.Type.CUSTOM).setKey(labelKey).setValue((ModelProto.MatchString)entry.getValue()).build());
            }
            RateLimitProto.Rule.Builder retRule = RateLimitProto.Rule.newBuilder().mergeFrom(rule).addAllArguments(arguments);
            retRules.add(retRule.build());
        }
        return retRules;
    }
}

