/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.ratelimit.client.flow;

import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.loadbalance.LoadBalancer;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.rpc.Criteria;
import com.tencent.polaris.client.flow.BaseFlow;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.ratelimit.client.flow.HostIdentifier;
import com.tencent.polaris.ratelimit.client.flow.ServiceIdentifier;
import com.tencent.polaris.ratelimit.client.flow.StreamCounterSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class AsyncRateLimitConnector {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncRateLimitConnector.class);
    private final Object counterSetLock = new Object();
    private final Map<HostIdentifier, StreamCounterSet> hostToStream = new HashMap<HostIdentifier, StreamCounterSet>();
    private final Map<String, StreamCounterSet> uniqueKeyToStream = new HashMap<String, StreamCounterSet>();
    private final List<String> coreRouters = new ArrayList<String>();

    public AsyncRateLimitConnector() {
        this.coreRouters.add("metadataRouter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamCounterSet getStreamCounterSet(Extensions extensions, ServiceKey remoteCluster, ServiceInstances remoteAddresses, String uniqueKey, ServiceIdentifier serviceIdentifier) {
        HostIdentifier hostIdentifier = this.getServiceInstance(extensions, remoteCluster, remoteAddresses, uniqueKey);
        if (hostIdentifier == null) {
            LOG.error("[getStreamCounterSet] ratelimit cluster service not found.");
            return null;
        }
        StreamCounterSet streamCounterSet = this.uniqueKeyToStream.get(uniqueKey);
        if (null != streamCounterSet && streamCounterSet.getIdentifier().equals(hostIdentifier)) {
            return streamCounterSet;
        }
        Object object = this.counterSetLock;
        synchronized (object) {
            if (null != streamCounterSet && streamCounterSet.getIdentifier().equals(hostIdentifier)) {
                return streamCounterSet;
            }
            if (null != streamCounterSet) {
                streamCounterSet.deleteInitRecord(serviceIdentifier);
                if (streamCounterSet.decreaseReference()) {
                    this.hostToStream.remove(hostIdentifier);
                }
            }
            if (null == (streamCounterSet = this.hostToStream.get(hostIdentifier))) {
                streamCounterSet = new StreamCounterSet(hostIdentifier);
            }
            streamCounterSet.addReference();
            this.hostToStream.put(hostIdentifier, streamCounterSet);
            this.uniqueKeyToStream.put(uniqueKey, streamCounterSet);
            return streamCounterSet;
        }
    }

    private HostIdentifier getServiceInstance(Extensions extensions, ServiceKey remoteCluster, ServiceInstances remoteAddresses, String hashValue) {
        Instance instance;
        if (null != remoteCluster) {
            instance = BaseFlow.commonGetOneInstance((Extensions)extensions, (ServiceKey)remoteCluster, this.coreRouters, (String)"ringHash", (String)"grpc", (String)hashValue);
        } else {
            LoadBalancer loadBalancer = (LoadBalancer)extensions.getPlugins().getPlugin(PluginTypes.LOAD_BALANCER.getBaseType(), "ringHash");
            Criteria criteria = new Criteria();
            criteria.setHashKey(hashValue);
            instance = BaseFlow.processLoadBalance((LoadBalancer)loadBalancer, (Criteria)criteria, (ServiceInstances)remoteAddresses);
        }
        if (instance == null) {
            LOG.error("can not found any instance by serviceKye:{}", (Object)remoteCluster);
            return null;
        }
        String host = instance.getHost();
        int port = instance.getPort();
        return new HostIdentifier(host, port);
    }
}

