/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.ratelimit.client.flow;

import com.tencent.polaris.api.config.provider.RateLimitConfig;
import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.cache.FlowCache;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.ratelimiter.InitCriteria;
import com.tencent.polaris.api.plugin.ratelimiter.QuotaResult;
import com.tencent.polaris.api.plugin.registry.AbstractResourceEventListener;
import com.tencent.polaris.api.plugin.registry.ResourceEventListener;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceRule;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.MapUtils;
import com.tencent.polaris.api.utils.RuleUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.flow.BaseFlow;
import com.tencent.polaris.client.flow.FlowControlParam;
import com.tencent.polaris.client.flow.ResourcesResponse;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.ratelimit.api.rpc.QuotaResponse;
import com.tencent.polaris.ratelimit.api.rpc.QuotaResultCode;
import com.tencent.polaris.ratelimit.client.flow.RateLimitExtension;
import com.tencent.polaris.ratelimit.client.flow.RateLimitWindow;
import com.tencent.polaris.ratelimit.client.flow.RateLimitWindowSet;
import com.tencent.polaris.ratelimit.client.pojo.CommonQuotaRequest;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import com.tencent.polaris.specification.api.v1.traffic.manage.RateLimitProto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class QuotaFlow
extends Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaFlow.class);
    private RateLimitExtension rateLimitExtension;
    private RateLimitConfig rateLimitConfig;
    private String clientId;
    private boolean enabled;
    private final Map<ServiceKey, RateLimitWindowSet> svcToWindowSet = new ConcurrentHashMap<ServiceKey, RateLimitWindowSet>();

    public void init(Extensions extensions) throws PolarisException {
        this.clientId = extensions.getValueContext().getClientId();
        this.rateLimitExtension = new RateLimitExtension(extensions);
        this.rateLimitConfig = this.rateLimitExtension.getExtensions().getConfiguration().getProvider().getRateLimit();
        this.enabled = this.rateLimitConfig.isEnable();
        extensions.getLocalRegistry().registerResourceListener((ResourceEventListener)new RateLimitRuleListener());
    }

    protected void doDestroy() {
        this.rateLimitExtension.destroy();
    }

    public QuotaResponse getQuota(CommonQuotaRequest request) throws PolarisException {
        if (!this.enabled) {
            return new QuotaResponse(new QuotaResult(QuotaResult.Code.QuotaResultOk, 0L, "disabled"));
        }
        List<RateLimitWindow> windows = this.lookupRateLimitWindow(request);
        if (CollectionUtils.isEmpty(windows)) {
            return new QuotaResponse(new QuotaResult(QuotaResult.Code.QuotaResultOk, 0L, "quota rule not exists"));
        }
        long maxWaitMs = 0L;
        for (RateLimitWindow rateLimitWindow : windows) {
            rateLimitWindow.init();
            QuotaResponse quotaResponse = new QuotaResponse(rateLimitWindow.allocateQuota(request.getCount()));
            if (quotaResponse.getCode() == QuotaResultCode.QuotaResultLimited) {
                quotaResponse.setActiveRule(rateLimitWindow.getRule());
                return quotaResponse;
            }
            if (quotaResponse.getWaitMs() <= maxWaitMs) continue;
            maxWaitMs = quotaResponse.getWaitMs();
        }
        return new QuotaResponse(new QuotaResult(QuotaResult.Code.QuotaResultOk, maxWaitMs, ""));
    }

    private List<RateLimitWindow> lookupRateLimitWindow(CommonQuotaRequest request) throws PolarisException {
        ResourcesResponse resourcesResponse = BaseFlow.syncGetResources((Extensions)this.rateLimitExtension.getExtensions(), (boolean)false, (ServiceEventKeysProvider)request, (FlowControlParam)request.getFlowControlParam());
        ServiceRule serviceRule = resourcesResponse.getServiceRule(request.getSvcEventKey());
        ArrayList<RateLimitWindow> windows = new ArrayList<RateLimitWindow>();
        List<RateLimitProto.Rule> rules = this.lookupRules(serviceRule, request.getMethod(), request.getArguments());
        if (CollectionUtils.isEmpty(rules)) {
            return windows;
        }
        ServiceKey serviceKey = request.getSvcEventKey().getServiceKey();
        for (RateLimitProto.Rule rule : rules) {
            InitCriteria initCriteria = new InitCriteria();
            initCriteria.setRule(rule);
            String labelsStr = QuotaFlow.formatLabelsToStr(request, initCriteria);
            RateLimitWindowSet rateLimitWindowSet = this.getRateLimitWindowSet(serviceKey);
            RateLimitWindow rateLimitWindow = rateLimitWindowSet.getRateLimitWindow(rule, labelsStr);
            if (null != rateLimitWindow) {
                windows.add(rateLimitWindow);
                continue;
            }
            windows.add(rateLimitWindowSet.addRateLimitWindow(request, labelsStr, this.rateLimitConfig, initCriteria));
        }
        return windows;
    }

    private RateLimitWindowSet getRateLimitWindowSet(ServiceKey serviceKey) {
        RateLimitWindowSet rateLimitWindowSet = this.svcToWindowSet.get(serviceKey);
        if (null != rateLimitWindowSet) {
            return rateLimitWindowSet;
        }
        return this.svcToWindowSet.computeIfAbsent(serviceKey, new Function<ServiceKey, RateLimitWindowSet>(){

            @Override
            public RateLimitWindowSet apply(ServiceKey serviceKey) {
                return new RateLimitWindowSet(serviceKey, QuotaFlow.this.rateLimitExtension, QuotaFlow.this.clientId);
            }
        });
    }

    private static String formatLabelsToStr(CommonQuotaRequest request, InitCriteria initCriteria) {
        RateLimitProto.Rule rule = initCriteria.getRule();
        ModelProto.MatchString method = rule.getMethod();
        boolean regexCombine = rule.getRegexCombine().getValue();
        String methodValue = "";
        if (null != method && !RuleUtils.isMatchAllValue((ModelProto.MatchString)method)) {
            if (regexCombine && method.getType() != ModelProto.MatchString.MatchStringType.EXACT) {
                methodValue = method.getValue().getValue();
            } else {
                methodValue = request.getMethod();
                if (method.getType() != ModelProto.MatchString.MatchStringType.EXACT) {
                    initCriteria.setRegexSpread(true);
                }
            }
        }
        List argumentsList = rule.getArgumentsList();
        ArrayList<String> tmpList = new ArrayList<String>();
        Map<Integer, Map<String, String>> arguments = request.getArguments();
        for (RateLimitProto.MatchArgument matchArgument : argumentsList) {
            String labelEntry;
            String labelValue;
            ModelProto.MatchString matcher = matchArgument.getValue();
            if (regexCombine && matcher.getType() != ModelProto.MatchString.MatchStringType.EXACT) {
                labelValue = matcher.getValue().getValue();
            } else {
                Map<String, String> stringStringMap = arguments.get(matchArgument.getType().ordinal());
                labelValue = QuotaFlow.getLabelValue(matchArgument, stringStringMap);
                if (matcher.getType() != ModelProto.MatchString.MatchStringType.EXACT) {
                    initCriteria.setRegexSpread(true);
                }
            }
            if (!StringUtils.isNotBlank((String)(labelEntry = QuotaFlow.getLabelEntry(matchArgument, labelValue)))) continue;
            tmpList.add(labelEntry);
        }
        Collections.sort(tmpList);
        return methodValue + "|" + String.join((CharSequence)"|", tmpList);
    }

    private static String getLabelEntry(RateLimitProto.MatchArgument matchArgument, String labelValue) {
        switch (matchArgument.getType()) {
            case CUSTOM: 
            case HEADER: 
            case QUERY: 
            case CALLER_SERVICE: {
                return matchArgument.getType().name() + ":" + matchArgument.getKey() + ":" + labelValue;
            }
            case METHOD: 
            case CALLER_IP: {
                return matchArgument.getType().name() + ":" + labelValue;
            }
        }
        return "";
    }

    private static String getLabelValue(RateLimitProto.MatchArgument matchArgument, Map<String, String> stringStringMap) {
        switch (matchArgument.getType()) {
            case CUSTOM: 
            case HEADER: 
            case QUERY: 
            case CALLER_SERVICE: {
                return stringStringMap.get(matchArgument.getKey());
            }
            case METHOD: 
            case CALLER_IP: {
                return stringStringMap.values().iterator().next();
            }
        }
        return stringStringMap.get(matchArgument.getKey());
    }

    private List<RateLimitProto.Rule> lookupRules(ServiceRule serviceRule, String method, Map<Integer, Map<String, String>> arguments) {
        if (null == serviceRule || null == serviceRule.getRule()) {
            return null;
        }
        RateLimitProto.RateLimit rateLimitProto = (RateLimitProto.RateLimit)serviceRule.getRule();
        List rulesList = rateLimitProto.getRulesList();
        if (CollectionUtils.isEmpty((Collection)rulesList)) {
            return null;
        }
        Function<String, Pattern> function = regex -> {
            FlowCache flowCache = this.rateLimitExtension.getExtensions().getFlowCache();
            return flowCache.loadOrStoreCompiledRegex(regex);
        };
        ArrayList<RateLimitProto.Rule> matchRules = new ArrayList<RateLimitProto.Rule>();
        for (RateLimitProto.Rule rule : rulesList) {
            boolean matchMethod;
            if (Objects.nonNull(rule.getDisable()) && rule.getDisable().getValue()) {
                LOG.debug("rule(id={}, name={}, revision={}) disable open, ignore", new Object[]{rule.getId().getValue(), rule.getName().getValue(), rule.getRevision().getValue()});
                continue;
            }
            if (rule.getAmountsCount() == 0) {
                LOG.debug("rule(id={}, name={}, revision={}) amounts count is zero, ignore", new Object[]{rule.getId().getValue(), rule.getName().getValue(), rule.getRevision().getValue()});
                continue;
            }
            ModelProto.MatchString methodMatcher = rule.getMethod();
            if (Objects.nonNull(methodMatcher) && !(matchMethod = RuleUtils.matchStringValue((ModelProto.MatchString)methodMatcher, (String)method, function))) continue;
            List argumentsList = rule.getArgumentsList();
            boolean matched = true;
            if (CollectionUtils.isNotEmpty((Collection)argumentsList)) {
                for (RateLimitProto.MatchArgument matchArgument : argumentsList) {
                    Map<String, String> stringStringMap = arguments.get(matchArgument.getType().ordinal());
                    if (CollectionUtils.isEmpty(stringStringMap)) {
                        matched = false;
                        break;
                    }
                    String labelValue = QuotaFlow.getLabelValue(matchArgument, stringStringMap);
                    matched = null == labelValue ? false : RuleUtils.matchStringValue((ModelProto.MatchString)matchArgument.getValue(), (String)labelValue, function);
                    if (matched) continue;
                    break;
                }
            }
            if (!matched) continue;
            matchRules.add(rule);
        }
        return matchRules;
    }

    private static Map<String, RateLimitProto.Rule> parseRules(RegistryCacheValue oldValue) {
        if (null == oldValue || !oldValue.isInitialized()) {
            return null;
        }
        ServiceRule serviceRule = (ServiceRule)oldValue;
        if (null == serviceRule.getRule()) {
            return null;
        }
        HashMap<String, RateLimitProto.Rule> ruleMap = new HashMap<String, RateLimitProto.Rule>();
        RateLimitProto.RateLimit rateLimit = (RateLimitProto.RateLimit)serviceRule.getRule();
        for (RateLimitProto.Rule rule : rateLimit.getRulesList()) {
            ruleMap.put(rule.getRevision().getValue(), rule);
        }
        return ruleMap;
    }

    private void deleteRules(ServiceKey serviceKey, Set<String> deletedRules) {
        LOG.info("[RateLimit]start to delete rules {} for service {}", deletedRules, (Object)serviceKey);
        RateLimitWindowSet rateLimitWindowSet = this.svcToWindowSet.get(serviceKey);
        if (null == rateLimitWindowSet) {
            return;
        }
        rateLimitWindowSet.deleteRules(deletedRules);
    }

    private class RateLimitRuleListener
    extends AbstractResourceEventListener {
        private RateLimitRuleListener() {
        }

        public void onResourceUpdated(ServiceEventKey svcEventKey, RegistryCacheValue oldValue, RegistryCacheValue newValue) {
            ServiceEventKey.EventType eventType = svcEventKey.getEventType();
            if (eventType != ServiceEventKey.EventType.RATE_LIMITING) {
                return;
            }
            Map oldRules = QuotaFlow.parseRules(oldValue);
            Map newRules = QuotaFlow.parseRules(newValue);
            if (MapUtils.isEmpty((Map)oldRules)) {
                return;
            }
            HashSet deletedRules = new HashSet();
            for (Map.Entry entry : oldRules.entrySet()) {
                if (!MapUtils.isEmpty((Map)newRules) && newRules.containsKey(entry.getKey())) continue;
                deletedRules.add(entry.getKey());
            }
            if (CollectionUtils.isNotEmpty(deletedRules)) {
                QuotaFlow.this.deleteRules(svcEventKey.getServiceKey(), deletedRules);
            }
        }

        public void onResourceDeleted(ServiceEventKey svcEventKey, RegistryCacheValue oldValue) {
            ServiceEventKey.EventType eventType = svcEventKey.getEventType();
            if (eventType != ServiceEventKey.EventType.RATE_LIMITING) {
                return;
            }
            Map oldRules = QuotaFlow.parseRules(oldValue);
            if (MapUtils.isEmpty((Map)oldRules)) {
                return;
            }
            QuotaFlow.this.deleteRules(svcEventKey.getServiceKey(), oldRules.keySet());
        }
    }
}

